/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.testutils.assembly.cas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jcvi.jillion.assembly.clc.cas.CasAlignment;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegion;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegionType;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.testutils.assembly.cas.DefaultCasAlignmentRegion;

final class DefaultCasAlignment
implements CasAlignment {
    private final long contigSequenceId;
    private final long startOfMatch;
    private final boolean readIsReversed;
    private final List<CasAlignmentRegion> alignmentRegions;

    public DefaultCasAlignment(long contigSequenceId, long startOfMatch, boolean readIsReversed, List<CasAlignmentRegion> alignmentRegions) {
        this.contigSequenceId = contigSequenceId;
        this.startOfMatch = startOfMatch;
        this.readIsReversed = readIsReversed;
        this.alignmentRegions = new ArrayList<CasAlignmentRegion>(alignmentRegions);
    }

    @Override
    public long getReferenceIndex() {
        return this.contigSequenceId;
    }

    @Override
    public List<CasAlignmentRegion> getAlignmentRegions() {
        return Collections.unmodifiableList(this.alignmentRegions);
    }

    @Override
    public long getStartOfMatch() {
        return this.startOfMatch;
    }

    @Override
    public boolean readIsReversed() {
        return this.readIsReversed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alignmentRegions.hashCode();
        result = 31 * result + (int)(this.contigSequenceId ^ this.contigSequenceId >>> 32);
        result = 31 * result + (this.readIsReversed ? 1231 : 1237);
        result = 31 * result + (int)(this.startOfMatch ^ this.startOfMatch >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCasAlignment)) {
            return false;
        }
        DefaultCasAlignment other = (DefaultCasAlignment)obj;
        if (!this.alignmentRegions.equals(other.alignmentRegions)) {
            return false;
        }
        if (this.contigSequenceId != other.contigSequenceId) {
            return false;
        }
        if (this.readIsReversed != other.readIsReversed) {
            return false;
        }
        return this.startOfMatch == other.startOfMatch;
    }

    public String toString() {
        return "DefaultCasAlignment [contigSequenceId=" + this.contigSequenceId + ", startOfMatch=" + this.startOfMatch + ", readIsReversed=" + this.readIsReversed + ", alignmentRegions=" + this.alignmentRegions + "]";
    }

    public static final class Builder
    implements org.jcvi.jillion.core.util.Builder<DefaultCasAlignment> {
        private final long contigSequenceId;
        private final long startOfMatch;
        private final boolean readIsReversed;
        List<CasAlignmentRegion> regions = new ArrayList<CasAlignmentRegion>();
        private CasAlignmentRegionType currentType;
        private long currentLength;

        public Builder(long contigSequenceId, long startOfMatch, Direction dir) {
            Objects.requireNonNull(dir);
            this.contigSequenceId = contigSequenceId;
            this.startOfMatch = startOfMatch;
            this.readIsReversed = dir == Direction.REVERSE;
            this.resetCurrentRegion();
        }

        private synchronized void resetCurrentRegion() {
            this.currentType = null;
            this.currentLength = 0L;
        }

        public final synchronized Builder addRegion(CasAlignmentRegionType type, long length) {
            if (type == null) {
                throw new IllegalArgumentException("type can not be null");
            }
            if (length < 1L) {
                throw new IllegalArgumentException("length can not < 1");
            }
            if (type.equals((Object)this.currentType)) {
                this.currentLength += length;
            } else {
                this.createAndResetCurrentRegion();
                this.currentType = type;
                this.currentLength = length;
            }
            return this;
        }

        private void createAndResetCurrentRegion() {
            if (this.currentType != null) {
                this.createCurrentRegion();
                this.resetCurrentRegion();
            }
        }

        private synchronized void createCurrentRegion() {
            this.regions.add(new DefaultCasAlignmentRegion(this.currentType, this.currentLength));
        }

        @Override
        public final DefaultCasAlignment build() {
            this.createAndResetCurrentRegion();
            return new DefaultCasAlignment(this.contigSequenceId, this.startOfMatch, this.readIsReversed, this.regions);
        }

        public Builder addRegion(CasAlignmentRegion alignmentRegion) {
            return this.addRegion(alignmentRegion.getType(), alignmentRegion.getLength());
        }
    }
}

