/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.testutils.assembly.cas;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jcvi.jillion.assembly.clc.cas.CasAlignment;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegion;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegionType;
import org.jcvi.jillion.assembly.clc.cas.CasFileInfo;
import org.jcvi.jillion.assembly.clc.cas.CasFileVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasMatch;
import org.jcvi.jillion.assembly.clc.cas.CasMatchVisitor;
import org.jcvi.jillion.assembly.clc.cas.CasParser;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.iter.ArrayIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriter;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriterBuilder;
import org.jcvi.jillion.testutils.NucleotideSequenceTestUtil;
import org.jcvi.jillion.testutils.assembly.cas.DefaultCasAlignment;
import org.jcvi.jillion.testutils.assembly.cas.FastaRecordWriter;
import org.jcvi.jillion.testutils.assembly.cas.RecordWriter;

public final class CasParserTestDouble
implements CasParser {
    private static final NucleotideSequence EMPTY_SEQ = NucleotideSequenceTestUtil.emptySeq();
    private static final CasMatch NOT_MATCHED = new CasMatch(){

        @Override
        public boolean readIsPartOfAPair() {
            return false;
        }

        @Override
        public boolean readHasMutlipleMatches() {
            return false;
        }

        @Override
        public boolean matchReported() {
            return false;
        }

        @Override
        public boolean hasMultipleAlignments() {
            return false;
        }

        @Override
        public Range getTrimRange() {
            return null;
        }

        @Override
        public int getScore() {
            return 0;
        }

        @Override
        public long getNumberOfReportedAlignments() {
            return 0L;
        }

        @Override
        public long getNumberOfMatches() {
            return 0L;
        }

        @Override
        public CasAlignment getChosenAlignment() {
            return null;
        }
    };
    private final List<CasMatch> matches;
    private final File workingDir;
    private final CasFileInfo referenceFileInfo;
    private final CasFileInfo readFileInfo;
    private final long numReferences;
    private final long numReads;

    private CasParserTestDouble(Builder builder) {
        this.matches = builder.matches;
        this.workingDir = builder.workingDir;
        this.referenceFileInfo = builder.refFileInfo;
        this.readFileInfo = builder.readFileInfo;
        this.numReads = builder.readCounter;
        this.numReferences = builder.references.size();
    }

    @Override
    public boolean canParse() {
        return true;
    }

    @Override
    public void parse(CasFileVisitor visitor) throws IOException {
        visitor.visitAssemblyProgramInfo("CasParserTestDouble", "1.0", "");
        visitor.visitMetaData(this.numReferences, this.numReads);
        visitor.visitNumberOfReferenceFiles(1L);
        visitor.visitNumberOfReadFiles(1L);
        visitor.visitReferenceFileInfo(this.referenceFileInfo);
        visitor.visitReadFileInfo(this.readFileInfo);
        final AtomicBoolean keepParsing = new AtomicBoolean(true);
        CasFileVisitor.CasVisitorCallback callback = new CasFileVisitor.CasVisitorCallback(){

            @Override
            public void haltParsing() {
                keepParsing.set(false);
            }

            @Override
            public boolean canCreateMemento() {
                return false;
            }

            @Override
            public CasFileVisitor.CasVisitorCallback.CasVisitorMemento createMemento() {
                throw new UnsupportedOperationException("mementos not supported");
            }
        };
        this.handleMatches(visitor.visitMatches(callback), keepParsing);
        if (keepParsing.get()) {
            visitor.visitEnd();
        } else {
            visitor.halted();
        }
    }

    private void handleMatches(CasMatchVisitor visitor, AtomicBoolean keepParsing) {
        if (visitor == null) {
            return;
        }
        for (CasMatch match : this.matches) {
            if (!keepParsing.get()) continue;
            visitor.visitMatch(match);
        }
        if (keepParsing.get()) {
            visitor.visitEnd();
        } else {
            visitor.halted();
        }
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    private static final class CasFileInfoImpl
    implements CasFileInfo {
        private final long numSeq;
        private final BigInteger residues;
        private final List<String> path;

        public CasFileInfoImpl(List<String> path, int numReads, long numResidues) {
            this.path = path;
            this.numSeq = numReads;
            this.residues = BigInteger.valueOf(numResidues);
        }

        public CasFileInfoImpl(String path, Map<String, NucleotideSequence> seqMap) {
            this.path = Collections.singletonList(path);
            this.numSeq = seqMap.size();
            long sum = 0L;
            for (NucleotideSequence s : seqMap.values()) {
                sum += s.getLength();
            }
            this.residues = BigInteger.valueOf(sum);
        }

        @Override
        public long getNumberOfSequences() {
            return this.numSeq;
        }

        @Override
        public BigInteger getNumberOfResidues() {
            return this.residues;
        }

        @Override
        public List<String> getFileNames() {
            return this.path;
        }
    }

    private static final class CasAlignmentRegionImpl
    implements CasAlignmentRegion {
        private final CasAlignmentRegionType type;
        private final int length;
        private final NucleotideSequence seq;

        private CasAlignmentRegionImpl(CasAlignmentRegionType type, int length) {
            Objects.requireNonNull(type);
            if (length < 1) {
                throw new IllegalArgumentException("length must be positive");
            }
            this.type = type;
            this.length = length;
            this.seq = null;
        }

        private CasAlignmentRegionImpl(CasAlignmentRegionType type, String seq) {
            Objects.requireNonNull(type);
            this.type = type;
            this.seq = new NucleotideSequenceBuilder(seq).build();
            this.length = (int)this.seq.getLength();
            if (this.length < 1) {
                throw new IllegalArgumentException("length must be positive");
            }
        }

        @Override
        public CasAlignmentRegionType getType() {
            return this.type;
        }

        @Override
        public long getLength() {
            return this.length;
        }
    }

    public static final class AlignmentBuilder {
        private final String refName;
        private final long ungappedStart;
        private final Direction dir;
        private final Builder builder;
        private final List<CasAlignmentRegionImpl> regions = new ArrayList<CasAlignmentRegionImpl>();

        private AlignmentBuilder(Builder builder, String refName, long ungappedStart, Direction dir) {
            this.builder = builder;
            this.refName = refName;
            this.ungappedStart = ungappedStart;
            this.dir = dir;
        }

        public AlignmentBuilder addAlignmentRegion(CasAlignmentRegionType type, int length) {
            this.regions.add(new CasAlignmentRegionImpl(type, length));
            return this;
        }

        public AlignmentBuilder addAlignmentRegion(CasAlignmentRegionType type, String sequence) {
            this.regions.add(new CasAlignmentRegionImpl(type, sequence));
            return this;
        }

        public Builder build() {
            return this.builder.match(this.refName, this.ungappedStart, this.dir, this.regions.toArray(new CasAlignmentRegionImpl[this.regions.size()]));
        }
    }

    public static class Builder {
        private final List<CasMatch> matches = new ArrayList<CasMatch>();
        Map<String, Integer> refIndex = new HashMap<String, Integer>();
        Map<String, NucleotideSequence> references = new LinkedHashMap<String, NucleotideSequence>();
        private final File workingDir;
        private final File referenceFile;
        private final ReadFileGenerator readFileGenerator;
        private int readCounter = 0;
        private long residueCounter = 0L;
        private NucleotideFastaWriter referenceWriter;
        private CasFileInfo refFileInfo;
        private CasFileInfo readFileInfo;

        public Builder(File workingDir) throws IOException {
            this(workingDir, new FastaRecordWriter(workingDir));
        }

        public Builder(File workingDir, RecordWriter ... recordWriters) throws IOException {
            this(workingDir, new File(workingDir, "reference.fasta"), new DefaultReadIdGenerator(recordWriters));
        }

        public Builder(File workingDir, File referenceFile, ReadFileGenerator readIdGenerator) throws IOException {
            Objects.requireNonNull(referenceFile);
            Objects.requireNonNull(readIdGenerator);
            this.readFileGenerator = readIdGenerator;
            this.referenceFile = referenceFile;
            this.referenceWriter = new NucleotideFastaWriterBuilder(referenceFile).build();
            this.workingDir = workingDir;
        }

        public Builder addReference(String name, String sequence) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(sequence);
            if (this.references.containsKey(name)) {
                throw new IllegalStateException("reference name already exists : " + name);
            }
            NucleotideSequence seq = new NucleotideSequenceBuilder(sequence).build();
            if (seq.getLength() == 0L) {
                throw new IllegalArgumentException("sequence must not be empty");
            }
            this.refIndex.put(name, this.refIndex.size());
            this.references.put(name, seq);
            try {
                this.referenceWriter.write(name, seq);
            }
            catch (IOException e) {
                throw new IllegalStateException("error writing reference sequence", e);
            }
            return this;
        }

        public AlignmentBuilder forwardMatch(String refName, long ungappedStart) {
            this.validateReadParameters(refName, ungappedStart);
            return new AlignmentBuilder(this, refName, ungappedStart, Direction.FORWARD);
        }

        private void validateReadParameters(String refName, long ungappedStart) {
            NucleotideSequence seq = this.references.get(refName);
            if (seq == null) {
                throw new IllegalArgumentException("unknown reference : " + refName);
            }
            if (ungappedStart > seq.getUngappedLength()) {
                throw new IllegalArgumentException("read starts beyond reference " + ungappedStart);
            }
        }

        public AlignmentBuilder reverseMatch(String refName, long ungappedStart) {
            this.validateReadParameters(refName, ungappedStart);
            return new AlignmentBuilder(this, refName, ungappedStart, Direction.REVERSE);
        }

        private Builder match(String refName, long ungappedStart, Direction dir, CasAlignmentRegionImpl[] alignmentRegions) {
            DefaultCasAlignment alignment;
            Integer index = this.refIndex.get(refName);
            ++this.readCounter;
            final boolean matchReported = this.matchReported(alignmentRegions);
            if (matchReported) {
                DefaultCasAlignment.Builder alignmentBuilder = new DefaultCasAlignment.Builder(index.longValue(), ungappedStart, dir);
                for (CasAlignmentRegionImpl alignmentRegion : alignmentRegions) {
                    alignmentBuilder.addRegion(alignmentRegion);
                }
                NucleotideSequence fullLengthReadSequence = this.computeFullRangeUngappedReadSequence2(refName, ungappedStart, dir, alignmentRegions);
                this.residueCounter += fullLengthReadSequence.getLength();
                try {
                    this.readFileGenerator.write(fullLengthReadSequence);
                }
                catch (IOException e) {
                    throw new IllegalStateException("error writing fasta read sequence", e);
                }
                alignment = alignmentBuilder.build();
            } else {
                alignment = null;
                try {
                    this.readFileGenerator.write(EMPTY_SEQ);
                }
                catch (IOException e) {
                    throw new IllegalStateException("error writing fasta read sequence", e);
                }
            }
            this.matches.add(new CasMatch(){

                @Override
                public boolean readIsPartOfAPair() {
                    return false;
                }

                @Override
                public boolean readHasMutlipleMatches() {
                    return false;
                }

                @Override
                public boolean matchReported() {
                    return matchReported;
                }

                @Override
                public boolean hasMultipleAlignments() {
                    return false;
                }

                @Override
                public Range getTrimRange() {
                    return null;
                }

                @Override
                public int getScore() {
                    return 0;
                }

                @Override
                public long getNumberOfReportedAlignments() {
                    return 1L;
                }

                @Override
                public long getNumberOfMatches() {
                    return 1L;
                }

                @Override
                public CasAlignment getChosenAlignment() {
                    return alignment;
                }
            });
            return this;
        }

        private NucleotideSequence computeFullRangeUngappedReadSequence2(String refName, long ungappedStart, Direction dir, CasAlignmentRegionImpl[] alignmentRegions) {
            NucleotideSequence refSeq = this.references.get(refName);
            NucleotideSequenceBuilder fullLengthBuilder = new NucleotideSequenceBuilder();
            ArrayIterator<CasAlignmentRegionImpl> alignmentIter = new ArrayIterator<CasAlignmentRegionImpl>(alignmentRegions);
            boolean inValidRange = false;
            long currentUngappedRefOffset = ungappedStart;
            while (alignmentIter.hasNext()) {
                char[] ns;
                CasAlignmentRegionImpl region = (CasAlignmentRegionImpl)alignmentIter.next();
                CasAlignmentRegionType type = region.getType();
                if (!inValidRange) {
                    if (type == CasAlignmentRegionType.INSERT) {
                        if (region.seq == null) {
                            ns = new char[(int)region.getLength()];
                            Arrays.fill(ns, 'N');
                            fullLengthBuilder.append(ns);
                        } else {
                            fullLengthBuilder.append(region.seq);
                        }
                    } else {
                        inValidRange = true;
                    }
                }
                if (!inValidRange) continue;
                switch (type) {
                    case INSERT: {
                        if (region.seq == null) {
                            ns = new char[(int)region.getLength()];
                            Arrays.fill(ns, 'N');
                            fullLengthBuilder.append(ns);
                            break;
                        }
                        fullLengthBuilder.append(region.seq);
                        break;
                    }
                    case DELETION: {
                        currentUngappedRefOffset += region.getLength();
                        break;
                    }
                    case MATCH_MISMATCH: {
                        if (region.seq == null) {
                            Range refRange = new Range.Builder(region.getLength()).shift(currentUngappedRefOffset).build();
                            Iterator refIter = refSeq.iterator(refRange);
                            while (refIter.hasNext()) {
                                fullLengthBuilder.append((Nucleotide)refIter.next());
                            }
                        } else {
                            fullLengthBuilder.append(region.seq);
                        }
                        currentUngappedRefOffset += region.getLength();
                        break;
                    }
                }
            }
            if (dir == Direction.REVERSE) {
                fullLengthBuilder.reverseComplement();
            }
            return fullLengthBuilder.build();
        }

        private boolean matchReported(CasAlignmentRegion[] alignmentRegions) {
            for (CasAlignmentRegion r : alignmentRegions) {
                if (r.getType() == CasAlignmentRegionType.INSERT) continue;
                return true;
            }
            return false;
        }

        public CasParserTestDouble build() throws IOException {
            if (this.readCounter == 0) {
                throw new IllegalStateException("must have at least one read");
            }
            List<String> paths = this.readFileGenerator.getPaths();
            IOUtil.closeAndIgnoreErrors((Closeable)this.readFileGenerator);
            try {
                this.referenceWriter.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("error closing referece fasta writer", e);
            }
            this.refFileInfo = new CasFileInfoImpl(this.referenceFile.getName(), this.references);
            this.readFileInfo = new CasFileInfoImpl(paths, this.readCounter, this.residueCounter);
            return new CasParserTestDouble(this);
        }

        public Builder unMatched() {
            ++this.readCounter;
            char[] ns = new char[10];
            Arrays.fill(ns, 'N');
            NucleotideSequence seq = new NucleotideSequenceBuilder(ns).build();
            try {
                this.readFileGenerator.write(seq);
            }
            catch (IOException e) {
                throw new IllegalStateException("error writing fasta read sequence", e);
            }
            this.matches.add(NOT_MATCHED);
            return this;
        }
    }

    private static final class DefaultReadIdGenerator
    implements ReadFileGenerator {
        private int readCounter = 0;
        private final List<RecordWriter> readWriters = new ArrayList<RecordWriter>();
        private final Iterator<RecordWriter> recordWriterIterator;
        private RecordWriter currentRecordWriter;

        public DefaultReadIdGenerator(RecordWriter ... recordWriters) {
            for (RecordWriter recordWriter : recordWriters) {
                if (recordWriter == null) {
                    throw new NullPointerException("record writer can not be null");
                }
                this.readWriters.add(recordWriter);
            }
            if (this.readWriters.isEmpty()) {
                throw new IllegalStateException("must have at least 1 RecordWriter");
            }
            this.recordWriterIterator = this.readWriters.iterator();
            this.currentRecordWriter = this.recordWriterIterator.next();
        }

        private void updateCurrentRecordWriterIfNeeded() {
            if (!this.currentRecordWriter.canWriteAnotherRecord()) {
                if (!this.recordWriterIterator.hasNext()) {
                    throw new IllegalStateException("no more record writers");
                }
                this.currentRecordWriter = this.recordWriterIterator.next();
            }
        }

        public String getNextId() {
            this.updateCurrentRecordWriterIfNeeded();
            return "read" + this.readCounter++;
        }

        @Override
        public void close() throws IOException {
            ArrayList<String> paths = new ArrayList<String>(this.readWriters.size());
            for (RecordWriter writer : this.readWriters) {
                paths.add(writer.getFile().getName());
                IOUtil.closeAndIgnoreErrors((Closeable)writer);
            }
        }

        @Override
        public List<String> getPaths() {
            ArrayList<String> paths = new ArrayList<String>(this.readWriters.size());
            for (RecordWriter writer : this.readWriters) {
                paths.add(writer.getFile().getName());
            }
            return paths;
        }

        @Override
        public void write(NucleotideSequence readSequence) throws IOException {
            String id = this.getNextId();
            this.currentRecordWriter.write(id, readSequence);
        }
    }

    public static interface ReadFileGenerator
    extends Closeable {
        public void write(NucleotideSequence var1) throws IOException;

        public List<String> getPaths();
    }
}

