/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.testutils;

import java.util.Random;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public final class NucleotideSequenceTestUtil {
    private static final NucleotideSequence EMPTY = new NucleotideSequenceBuilder("").build();
    private static final Random RANDOM = new Random();

    private NucleotideSequenceTestUtil() {
    }

    public static NucleotideSequence emptySeq() {
        return EMPTY;
    }

    public static NucleotideSequence create(String seq) {
        return new NucleotideSequenceBuilder(seq).turnOffDataCompression(true).build();
    }

    public static NucleotideSequence create(String s, int times) {
        int motifLength = s.length();
        NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(motifLength * times).turnOffDataCompression(true);
        for (int i = 0; i < times; ++i) {
            builder.append(s);
        }
        return builder.build();
    }

    public static NucleotideSequence createRandom(int length) {
        NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(NucleotideSequenceTestUtil.nextRandom());
        }
        builder.turnOffDataCompression(true);
        return builder.build();
    }

    private static Nucleotide nextRandom() {
        switch (RANDOM.nextInt(4)) {
            case 0: {
                return Nucleotide.Adenine;
            }
            case 1: {
                return Nucleotide.Cytosine;
            }
            case 2: {
                return Nucleotide.Guanine;
            }
        }
        return Nucleotide.Thymine;
    }
}

