/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.shared.fasta;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.fasta.FastaRecord;
import org.jcvi.jillion.fasta.FastaWriter;
import org.jcvi.jillion.internal.core.io.OutputStreamFactory;
import org.jcvi.jillion.internal.fasta.FastaUtil;

public abstract class AbstractFastaRecordWriter<S, T extends Sequence<S>, F extends FastaRecord<S, T>>
implements FastaWriter<S, T, F> {
    private final Writer writer;
    private final int numberOfResiduesPerLine;
    private final boolean hasSymbolSeparator;
    private final String eol;
    private final Object lock = new Object();
    private final StringBuilder recordBuffer = new StringBuilder(2000);

    protected AbstractFastaRecordWriter(OutputStream out, int numberOfResiduesPerLine, Charset charSet, String eol) {
        this.writer = new BufferedWriter(new OutputStreamWriter(out, charSet));
        this.numberOfResiduesPerLine = numberOfResiduesPerLine;
        this.hasSymbolSeparator = this.hasSymbolSeparator();
        this.eol = eol;
    }

    @Override
    public final void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @Override
    public final void write(F record) throws IOException {
        this.write(record.getId(), record.getSequence(), record.getComment());
    }

    @Override
    public final void write(String id, T sequence) throws IOException {
        this.write(id, sequence, null);
    }

    @Override
    public final void write(String id, T sequence, String optionalComment) throws IOException {
        String formattedString = this.toFormattedString(id, sequence, optionalComment);
        this.writer.write(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toFormattedString(String id, T sequence, String comment) {
        String ret;
        Object object = this.lock;
        synchronized (object) {
            this.recordBuffer.setLength(0);
            this.appendDefline(id, comment, this.recordBuffer);
            this.appendRecordBody(sequence, this.recordBuffer);
            ret = this.recordBuffer.toString();
        }
        return ret;
    }

    private void appendRecordBody(T sequence, StringBuilder record) {
        Iterator iter = sequence.iterator();
        if (iter.hasNext()) {
            record.append(this.getStringRepresentationFor(iter.next()));
        }
        int count = 1;
        while (iter.hasNext()) {
            if (this.numberOfResiduesPerLine != -1 && count % this.numberOfResiduesPerLine == 0) {
                record.append(this.eol);
            } else if (this.hasSymbolSeparator) {
                record.append(this.getSymbolSeparator());
            }
            record.append(this.getStringRepresentationFor(iter.next()));
            ++count;
        }
        record.append(this.eol);
    }

    protected abstract boolean hasSymbolSeparator();

    protected abstract String getSymbolSeparator();

    protected abstract String getStringRepresentationFor(S var1);

    private void appendDefline(String id, String comment, StringBuilder record) {
        record.append(FastaUtil.getHeaderPrefix()).append(id);
        if (comment != null) {
            record.append(' ').append(comment);
        }
        record.append(this.eol);
    }

    public static abstract class AbstractBuilder<S, T extends Sequence<S>, F extends FastaRecord<S, T>, W extends FastaWriter<S, T, F>, B extends AbstractBuilder<S, T, F, W, B>>
    implements Builder<W> {
        public static final int ALL_ON_ONE_LINE = -1;
        private static final Charset DEFAULT_CHARSET = IOUtil.UTF_8;
        private static final String DEFAULT_LINE_SEPARATOR = FastaUtil.getLineSeparator();
        private static final int DEFAULT_CACHE_SIZE = 1024;
        private final OutputStream out;
        private int numberOfSymbolsPerLine;
        private String eol = DEFAULT_LINE_SEPARATOR;
        private Comparator<F> comparator = null;
        private Integer inMemoryCacheSize;
        private File tmpDir;
        private Charset charSet = DEFAULT_CHARSET;

        public AbstractBuilder(OutputStream out) {
            if (out == null) {
                throw new NullPointerException("outputstream can not be null");
            }
            this.out = out;
            this.numberPerLine(this.getDefaultNumberOfSymbolsPerLine());
        }

        protected abstract B getThis();

        protected abstract int getDefaultNumberOfSymbolsPerLine();

        public AbstractBuilder(File outputFile) throws IOException {
            this.out = OutputStreamFactory.create(outputFile);
            this.numberPerLine(this.getDefaultNumberOfSymbolsPerLine());
        }

        public final B charset(Charset charset) {
            if (charset == null) {
                throw new NullPointerException("charset can not be null");
            }
            this.charSet = charset;
            return this.getThis();
        }

        public final B lineSeparator(String eol) {
            if (eol == null) {
                this.eol = DEFAULT_LINE_SEPARATOR;
            } else {
                if (eol.isEmpty()) {
                    throw new IllegalArgumentException("line separator can not be empty");
                }
                this.eol = eol;
            }
            return this.getThis();
        }

        public final B numberPerLine(int numberPerLine) {
            if (numberPerLine < 1) {
                throw new IllegalArgumentException("number per line must be >=1");
            }
            this.numberOfSymbolsPerLine = numberPerLine;
            return this.getThis();
        }

        public final B allBasesOnOneLine() {
            this.numberOfSymbolsPerLine = -1;
            return this.getThis();
        }

        @Override
        public W build() {
            W writer = this.create(this.out, this.numberOfSymbolsPerLine, this.charSet, this.eol);
            if (this.comparator == null) {
                return writer;
            }
            if (this.inMemoryCacheSize == null) {
                return this.createInMemorySortedWriterWriter((FastaWriter<S, T, F>)writer, this.comparator);
            }
            return this.createTmpDirSortedWriterWriter((FastaWriter<S, T, F>)writer, this.comparator, this.inMemoryCacheSize, this.tmpDir);
        }

        protected abstract W createTmpDirSortedWriterWriter(FastaWriter<S, T, F> var1, Comparator<F> var2, int var3, File var4);

        protected abstract W createInMemorySortedWriterWriter(FastaWriter<S, T, F> var1, Comparator<F> var2);

        protected abstract W create(OutputStream var1, int var2, Charset var3, String var4);

        public B sortInMemoryOnly(Comparator<F> comparator) {
            Objects.requireNonNull(comparator);
            this.comparator = comparator;
            this.inMemoryCacheSize = null;
            this.tmpDir = null;
            return this.getThis();
        }

        public B sort(Comparator<F> comparator) {
            return this.sort(comparator, 1024);
        }

        public B sort(Comparator<F> comparator, int inMemoryCacheSize) {
            return this.sort(comparator, inMemoryCacheSize, null);
        }

        public B sort(Comparator<F> comparator, int inMemoryCacheSize, File dir) {
            Objects.requireNonNull(comparator);
            if (inMemoryCacheSize < 1) {
                throw new IllegalArgumentException("in memory cache size must be positive");
            }
            if (dir != null) {
                if (!dir.exists()) {
                    throw new IllegalArgumentException("tmpDir does not exist: " + dir.getAbsolutePath());
                }
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("tmpDir is not a directory: " + dir.getAbsolutePath());
                }
            }
            this.comparator = comparator;
            this.inMemoryCacheSize = inMemoryCacheSize;
            this.tmpDir = dir;
            return this.getThis();
        }
    }
}

