/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.shared.fasta;

import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.fasta.FastaRecord;

public abstract class AbstractFastaRecordBuilder<T, S extends Sequence<T>, F extends FastaRecord<T, S>, B extends AbstractFastaRecordBuilder<T, S, F, B>> {
    private final String id;
    private final S sequence;
    private String comment = null;

    public AbstractFastaRecordBuilder(String id, S sequence) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (sequence == null) {
            throw new NullPointerException("sequence can not be null");
        }
        this.id = id;
        this.sequence = sequence;
    }

    protected abstract B getThis();

    protected abstract B newBuilder(String var1, S var2, String var3);

    public B comment(String comment) {
        this.comment = comment;
        return this.getThis();
    }

    public B withId(String id) {
        return this.newBuilder(id, this.sequence, this.comment);
    }

    public B withSequence(S sequence) {
        return this.newBuilder(this.id, sequence, this.comment);
    }

    public F build() {
        return this.createNewInstance(this.id, this.sequence, this.comment);
    }

    protected abstract F createNewInstance(String var1, S var2, String var3);
}

