/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.shared.fasta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.fasta.FastaDataStore;
import org.jcvi.jillion.fasta.FastaFileParser;
import org.jcvi.jillion.fasta.FastaParser;
import org.jcvi.jillion.fasta.FastaRecord;

public abstract class AbstractFastaFileDataStoreBuilder<T, S extends Sequence<T>, F extends FastaRecord<T, S>, SD extends DataStore<S>, D extends FastaDataStore<T, S, F, SD>> {
    private final FastaParser parser;
    private Predicate<String> filter = id -> true;
    private Predicate<F> recordFilter = null;
    private DataStoreProviderHint hint = DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_SPEED;

    protected AbstractFastaFileDataStoreBuilder(File fastaFile) throws IOException {
        this.parser = FastaFileParser.create(fastaFile);
    }

    protected AbstractFastaFileDataStoreBuilder(InputStreamSupplier inputStreamSupplier) throws IOException {
        this.parser = FastaFileParser.create(inputStreamSupplier);
    }

    protected AbstractFastaFileDataStoreBuilder(InputStream fastaFileAsStream) throws IOException {
        this.parser = FastaFileParser.create(fastaFileAsStream);
    }

    protected AbstractFastaFileDataStoreBuilder(FastaParser parser) {
        if (parser == null) {
            throw new NullPointerException("fasta parser can not be null");
        }
        this.parser = parser;
    }

    protected AbstractFastaFileDataStoreBuilder<T, S, F, SD, D> filter(Predicate<String> filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.filter = filter;
        return this;
    }

    protected AbstractFastaFileDataStoreBuilder<T, S, F, SD, D> filterRecords(Predicate<F> filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.recordFilter = filter;
        return this;
    }

    protected AbstractFastaFileDataStoreBuilder<T, S, F, SD, D> hint(DataStoreProviderHint hint) {
        if (hint == null) {
            throw new NullPointerException("hint can not be null");
        }
        this.hint = hint;
        return this;
    }

    protected D build() throws IOException {
        return this.createNewInstance(this.parser, this.hint, this.filter, this.recordFilter);
    }

    protected abstract D createNewInstance(FastaParser var1, DataStoreProviderHint var2, Predicate<String> var3, Predicate<F> var4) throws IOException;
}

