/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.transform;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jcvi.jillion.assembly.AssemblyTransformationService;
import org.jcvi.jillion.assembly.AssemblyTransformer;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaFileDataStoreBuilder;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamParserFactory;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamRecordFlag;
import org.jcvi.jillion.sam.SamRecordFlags;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.cigar.Cigar;
import org.jcvi.jillion.sam.cigar.CigarElement;
import org.jcvi.jillion.sam.cigar.CigarOperation;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReferenceSequence;
import org.jcvi.jillion.sam.transform.SamGappedReferenceBuilderVisitor;

public final class SamTransformationService
implements AssemblyTransformationService {
    private final NucleotideSequenceDataStore referenceDataStore;
    private final SamParser parser;

    public SamTransformationService(File samFile, File referenceFasta) throws IOException {
        this.parser = SamParserFactory.create(samFile);
        NucleotideFastaFileDataStore ungappedReferenceDataStore = new NucleotideFastaFileDataStoreBuilder(referenceFasta).build();
        this.referenceDataStore = SamGappedReferenceBuilderVisitor.createGappedReferencesFrom(this.parser, ungappedReferenceDataStore);
    }

    @Override
    public void transform(AssemblyTransformer transformer) {
        if (transformer == null) {
            throw new NullPointerException("transformer can not be null");
        }
        try {
            SamTransformerVisitor visitor = new SamTransformerVisitor(this.referenceDataStore, transformer);
            this.parser.parse(visitor);
        }
        catch (Exception e) {
            throw new IllegalStateException("error parsing sam file", e);
        }
    }

    private static final class SamTransformerVisitor
    implements SamVisitor {
        private final AssemblyTransformer transformer;
        private final NucleotideSequenceDataStore referenceDataStore;
        private final Map<String, GrowableIntArray> gapOffsetMap;

        public SamTransformerVisitor(NucleotideSequenceDataStore referenceDataStore, AssemblyTransformer transformer) throws DataStoreException {
            this.referenceDataStore = referenceDataStore;
            this.transformer = transformer;
            this.gapOffsetMap = new HashMap<String, GrowableIntArray>(MapUtil.computeMinHashMapSizeWithoutRehashing(referenceDataStore.getNumberOfRecords()));
        }

        @Override
        public void visitHeader(SamVisitor.SamVisitorCallback callback, SamHeader header) {
            for (SamReferenceSequence refSeq : header.getReferenceSequences()) {
                String id = refSeq.getName();
                try {
                    NucleotideSequence ref = (NucleotideSequence)this.referenceDataStore.get(id);
                    if (ref == null) {
                        throw new IllegalStateException("error could not find reference sequence in fasta file with id " + id);
                    }
                    this.gapOffsetMap.put(id, new GrowableIntArray(ref.getGapOffsets()));
                    this.transformer.referenceOrConsensus(id, ref);
                }
                catch (DataStoreException e) {
                    throw new IllegalStateException("error getting reference sequence from fasta file", e);
                }
            }
        }

        @Override
        public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
            if (record.isPrimary()) {
                if (record.mapped()) {
                    String refName = record.getReferenceName();
                    try {
                        Range validRange;
                        QualitySequence quals;
                        NucleotideSequence rawSequence;
                        NucleotideSequence referenceSeq = (NucleotideSequence)this.referenceDataStore.get(refName);
                        Direction dir = record.getDirection();
                        Cigar cigar = record.getCigar();
                        int rawLength = cigar.getUnpaddedReadLength(Cigar.ClipType.RAW);
                        int gappedStartOffset = referenceSeq.getGappedOffsetFor(record.getStartPosition() - 1);
                        if (dir == Direction.FORWARD) {
                            rawSequence = record.getSequence();
                            quals = record.getQualities();
                            validRange = cigar.getValidRange();
                        } else {
                            rawSequence = new NucleotideSequenceBuilder(record.getSequence()).reverseComplement().build();
                            quals = record.getQualities() == null ? null : new QualitySequenceBuilder(record.getQualities()).reverse().build();
                            validRange = AssemblyUtil.reverseComplementValidRange(cigar.getValidRange(), rawLength);
                        }
                        NucleotideSequence gappedReadSequence = this.toGappedTrimmedSequenceBuilder(cigar, rawSequence, this.gapOffsetMap.get(refName), gappedStartOffset, dir).build();
                        String readName = record.getQueryName();
                        SamRecordFlags flags = record.getFlags();
                        if (flags.contains(SamRecordFlag.HAS_MATE_PAIR)) {
                            readName = record.getObservedTemplateLength() >= 0 ? readName + "/1" : readName + "/2";
                        }
                        this.transformer.aligned(readName, rawSequence, quals, null, null, refName, gappedStartOffset, dir, gappedReadSequence, new ReadInfo(validRange, rawLength));
                    }
                    catch (DataStoreException e) {
                        throw new IllegalStateException("unknown reference " + refName, e);
                    }
                } else {
                    this.transformer.notAligned(record.getQueryName(), record.getSequence(), record.getQualities(), null, null);
                }
            }
        }

        @Override
        public void visitEnd() {
            this.transformer.endAssembly();
        }

        @Override
        public void halted() {
            this.transformer.endAssembly();
        }

        private NucleotideSequenceBuilder toGappedTrimmedSequenceBuilder(Cigar cigar, NucleotideSequence rawUngappedSequence, GrowableIntArray refGaps, int gappedStartOffset, Direction dir) {
            if (rawUngappedSequence.getNumberOfGaps() != 0) {
                throw new IllegalArgumentException("rawUngapped Sequence can not have gaps");
            }
            NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder((int)rawUngappedSequence.getLength());
            int referenceOffset = gappedStartOffset;
            Iterator<Object> ungappedBasesIter = dir == Direction.FORWARD ? rawUngappedSequence.iterator() : new NucleotideSequenceBuilder(rawUngappedSequence).reverseComplement().iterator();
            for (CigarElement e : cigar) {
                if (e.getOp() == CigarOperation.HARD_CLIP || e.getOp() == CigarOperation.SOFT_CLIP) {
                    for (int i = 0; i < e.getLength(); ++i) {
                        ungappedBasesIter.next();
                    }
                    continue;
                }
                referenceOffset = this.appendBases(builder, ungappedBasesIter, refGaps, referenceOffset, e);
            }
            return builder;
        }

        private int appendBases(NucleotideSequenceBuilder builder, Iterator<Nucleotide> ungappedReadBaseIterator, GrowableIntArray refGaps, int refOffset, CigarElement e) {
            int ret = refOffset;
            for (int i = 0; i < e.getLength(); ++i) {
                if (e.getOp() != CigarOperation.INSERTION) {
                    while (refGaps.binarySearch(ret) >= 0) {
                        builder.append(Nucleotide.Gap);
                        ++ret;
                    }
                }
                if (e.getOp() == CigarOperation.PADDING) {
                    builder.delete(new Range.Builder(1L).shift(builder.getLength() - 1L).build());
                } else if (e.getOp() == CigarOperation.DELETION || e.getOp() == CigarOperation.SKIPPED) {
                    builder.append(Nucleotide.Gap);
                } else {
                    builder.append(ungappedReadBaseIterator.next());
                }
                ++ret;
            }
            return ret;
        }
    }
}

