/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.transform;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.GappedReferenceBuilder;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.fasta.nt.NucleotideFastaDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaRecord;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.cigar.Cigar;
import org.jcvi.jillion.sam.cigar.CigarElement;
import org.jcvi.jillion.sam.cigar.CigarOperation;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReferenceSequence;

final class SamGappedReferenceBuilderVisitor
implements SamVisitor {
    Map<String, GappedReferenceBuilder> builders = new LinkedHashMap<String, GappedReferenceBuilder>();

    public static NucleotideSequenceDataStore createGappedReferencesFrom(SamParser parser, NucleotideFastaDataStore ungappedReferenceDataStore) throws IOException {
        SamGappedReferenceBuilderVisitor visitor;
        try {
            visitor = new SamGappedReferenceBuilderVisitor(ungappedReferenceDataStore);
        }
        catch (DataStoreException e) {
            throw new IOException("error parsing reference datastore", e);
        }
        parser.parse(visitor);
        return visitor.buildGappedReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SamGappedReferenceBuilderVisitor(NucleotideFastaDataStore ungappedReferenceDataStore) throws DataStoreException {
        StreamingIterator iter = null;
        try {
            iter = ungappedReferenceDataStore.iterator();
            while (iter.hasNext()) {
                NucleotideFastaRecord next = (NucleotideFastaRecord)iter.next();
                this.builders.put(next.getId(), new GappedReferenceBuilder((NucleotideSequence)next.getSequence()));
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
    }

    @Override
    public void visitHeader(SamVisitor.SamVisitorCallback callback, SamHeader header) {
        HashSet<String> namesUsed = new HashSet<String>();
        for (SamReferenceSequence ref : header.getReferenceSequences()) {
            namesUsed.add(ref.getName());
        }
        Iterator<Map.Entry<String, GappedReferenceBuilder>> entryIter = this.builders.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<String, GappedReferenceBuilder> entry = entryIter.next();
            if (namesUsed.contains(entry.getKey())) continue;
            entryIter.remove();
        }
    }

    @Override
    public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
        if (record.isPrimary() && record.mapped()) {
            int offset;
            String refName = record.getReferenceName();
            GappedReferenceBuilder refBuilder = this.builders.get(refName);
            int currentOffset = offset = record.getStartPosition() - 1;
            Cigar cigar = record.getCigar();
            Iterator<CigarElement> iter = cigar.getElementIterator();
            while (iter.hasNext()) {
                CigarElement element = iter.next();
                CigarOperation op = element.getOp();
                if (op == CigarOperation.HARD_CLIP || op == CigarOperation.SOFT_CLIP || op == CigarOperation.PADDING) continue;
                if (op == CigarOperation.INSERTION) {
                    refBuilder.addReadInsertion(currentOffset, element.getLength());
                    continue;
                }
                currentOffset += element.getLength();
            }
        }
    }

    @Override
    public void halted() {
    }

    @Override
    public void visitEnd() {
    }

    private NucleotideSequenceDataStore buildGappedReferences() {
        LinkedHashMap<String, NucleotideSequence> map = new LinkedHashMap<String, NucleotideSequence>();
        for (Map.Entry<String, GappedReferenceBuilder> entry : this.builders.entrySet()) {
            map.put(entry.getKey(), entry.getValue().build());
        }
        return DataStore.of(map, NucleotideSequenceDataStore.class);
    }
}

