/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.transform;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.assembly.AssemblyTransformationService;
import org.jcvi.jillion.assembly.AssemblyTransformer;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.internal.core.util.GrowableIntArray;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamParserFactory;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamRecordFlag;
import org.jcvi.jillion.sam.SamRecordFlags;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.cigar.Cigar;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReferenceSequence;

public final class PaddedSamTransformationService
implements AssemblyTransformationService {
    private final SamParser parser;

    public PaddedSamTransformationService(File paddedSamOrBamFile) throws IOException {
        this.parser = SamParserFactory.create(paddedSamOrBamFile);
    }

    @Override
    public void transform(AssemblyTransformer transformer) {
        if (transformer == null) {
            throw new NullPointerException("transformer can not be null");
        }
        try {
            SamTransformerVisitor visitor = new SamTransformerVisitor(transformer);
            this.parser.parse(visitor);
        }
        catch (Exception e) {
            throw new IllegalStateException("error parsing sam file", e);
        }
    }

    private static final class SamTransformerVisitor
    implements SamVisitor {
        private final AssemblyTransformer transformer;
        private Map<String, GrowableIntArray> gapOffsetMap;
        private Map<String, NucleotideSequence> paddedReferenceSequences;
        private Set<String> referenceNames;

        public SamTransformerVisitor(AssemblyTransformer transformer) throws DataStoreException {
            this.transformer = transformer;
        }

        @Override
        public void visitHeader(SamVisitor.SamVisitorCallback callback, SamHeader header) {
            Collection<SamReferenceSequence> referenceSequences = header.getReferenceSequences();
            int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(referenceSequences.size());
            this.referenceNames = new HashSet<String>(capacity);
            this.paddedReferenceSequences = new HashMap<String, NucleotideSequence>(capacity);
            this.gapOffsetMap = new HashMap<String, GrowableIntArray>(capacity);
            for (SamReferenceSequence refSeq : referenceSequences) {
                this.referenceNames.add(refSeq.getName());
            }
        }

        private boolean isReference(SamRecord record) {
            return this.referenceNames.contains(record.getQueryName()) && record.getStartPosition() == 1 && record.getFlags().maybeReferenceSequence();
        }

        @Override
        public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
            if (record.isPrimary()) {
                if (record.mapped()) {
                    Range validRange;
                    QualitySequence quals;
                    NucleotideSequence rawSequence;
                    String refName = record.getReferenceName();
                    NucleotideSequence referenceSeq = this.paddedReferenceSequences.get(refName);
                    if (referenceSeq == null) {
                        throw new IllegalStateException("error padded reference sequence not defined in sam/bam file : " + refName);
                    }
                    Direction dir = record.getDirection();
                    Cigar cigar = record.getCigar();
                    int rawLength = cigar.getUnpaddedReadLength(Cigar.ClipType.RAW);
                    int gappedStartOffset = record.getStartPosition() - 1;
                    if (dir == Direction.FORWARD) {
                        rawSequence = record.getSequence();
                        quals = record.getQualities();
                        validRange = cigar.getValidRange();
                    } else {
                        rawSequence = new NucleotideSequenceBuilder(record.getSequence()).reverseComplement().build();
                        quals = record.getQualities() == null ? null : new QualitySequenceBuilder(record.getQualities()).reverse().build();
                        validRange = AssemblyUtil.reverseComplementValidRange(cigar.getValidRange(), rawLength);
                    }
                    NucleotideSequence gappedReadSequence = this.removeHardClipsFrom(cigar).toGappedTrimmedSequence(record.getSequence());
                    String readName = record.getQueryName();
                    SamRecordFlags flags = record.getFlags();
                    if (flags.contains(SamRecordFlag.HAS_MATE_PAIR)) {
                        readName = record.getObservedTemplateLength() >= 0 ? readName + "/1" : readName + "/2";
                    }
                    this.transformer.aligned(readName, rawSequence, quals, null, null, refName, gappedStartOffset, dir, gappedReadSequence, new ReadInfo(validRange, rawLength));
                } else if (this.isReference(record)) {
                    String name = record.getQueryName();
                    Cigar cigar = record.getCigar();
                    NucleotideSequence gappedSequence = cigar.toGappedTrimmedSequence(record.getSequence());
                    this.paddedReferenceSequences.put(name, gappedSequence);
                    this.gapOffsetMap.put(name, new GrowableIntArray(gappedSequence.getGapOffsets()));
                    this.transformer.referenceOrConsensus(name, gappedSequence);
                } else {
                    this.transformer.notAligned(record.getQueryName(), record.getSequence(), record.getQualities(), null, null);
                }
            }
        }

        private Cigar removeHardClipsFrom(Cigar cigar) {
            return new Cigar.Builder(cigar).removeHardClips().build();
        }

        @Override
        public void visitEnd() {
            this.transformer.endAssembly();
        }

        @Override
        public void halted() {
            this.transformer.endAssembly();
        }
    }
}

