/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.index;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.sam.index.BamIndexer;
import org.jcvi.jillion.internal.sam.index.IndexUtil;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamParserFactory;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.SortOrder;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.index.BamIndex;

public final class BamIndexFileWriterBuilder {
    private boolean includeMetaData = false;
    private boolean assumeSorted = false;
    private File outputBaiFile;
    private File inputBamFile;

    public BamIndexFileWriterBuilder(File inputBamFile) throws IOException {
        this(inputBamFile, new File(inputBamFile.getParentFile(), inputBamFile.getName() + ".bai"));
    }

    public BamIndexFileWriterBuilder(File inputBamFile, File outputBaiFile) throws IOException {
        if (inputBamFile == null) {
            throw new NullPointerException("input bam file can not be null");
        }
        if (outputBaiFile == null) {
            throw new NullPointerException("output bai file can not be null");
        }
        if (!"bam".equalsIgnoreCase(FileUtil.getExtension(inputBamFile))) {
            throw new IllegalArgumentException("input file is not a bam file " + inputBamFile.getAbsolutePath());
        }
        if (!"bai".equalsIgnoreCase(FileUtil.getExtension(outputBaiFile))) {
            throw new IllegalArgumentException("input file is not a bai file " + outputBaiFile.getAbsolutePath());
        }
        if (!inputBamFile.exists()) {
            throw new FileNotFoundException("input bam file must exist " + inputBamFile.getAbsolutePath());
        }
        IOUtil.mkdirs(outputBaiFile.getParentFile());
        this.inputBamFile = inputBamFile;
        this.outputBaiFile = outputBaiFile;
    }

    public BamIndexFileWriterBuilder assumeSorted(boolean assumeSorted) {
        this.assumeSorted = assumeSorted;
        return this;
    }

    public BamIndexFileWriterBuilder includeMetaData(boolean includeMetaData) {
        this.includeMetaData = includeMetaData;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File build() throws IOException {
        File file;
        SamParser parser = SamParserFactory.create(this.inputBamFile);
        BamIndexSamVisitor visitor = new BamIndexSamVisitor(this.assumeSorted);
        parser.parse(visitor);
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.outputBaiFile));
            IndexUtil.writeIndex(out, visitor.createBamIndex(), this.includeMetaData);
            file = this.outputBaiFile;
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(out);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)out);
        return file;
    }

    private static class BamIndexSamVisitor
    implements SamVisitor {
        private BamIndexer indexer;
        private final boolean assumeSorted;

        public BamIndexSamVisitor(boolean assumeSorted) {
            this.assumeSorted = assumeSorted;
        }

        @Override
        public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
            this.indexer.addRecord(record, start, end);
        }

        @Override
        public void visitHeader(SamVisitor.SamVisitorCallback callback, SamHeader header) {
            if (!this.assumeSorted && !header.getSortOrder().equals((Object)SortOrder.COORDINATE)) {
                throw new IllegalStateException("bam file not in coordinate sort order : " + (Object)((Object)header.getSortOrder()));
            }
            this.indexer = new BamIndexer(header);
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        public BamIndex createBamIndex() {
            return this.indexer.createBamIndex();
        }
    }
}

