/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.index;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.internal.sam.index.IndexUtil;
import org.jcvi.jillion.sam.AbstractSamVisitor;
import org.jcvi.jillion.sam.SamParserFactory;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReferenceSequence;
import org.jcvi.jillion.sam.index.ReferenceIndex;

public final class BamIndex {
    private final Map<String, Integer> indexOfRefNames;
    private final List<ReferenceIndex> indexes;
    private final Long totalNumberOfUnmappedReads;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BamIndex createFromFiles(File bam, File bai) throws IOException {
        BamIndex bamIndex;
        SamHeaderParser headerParser = new SamHeaderParser();
        SamParserFactory.create(bam).parse(headerParser);
        SamHeader header = headerParser.getHeader();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(bai));
            bamIndex = IndexUtil.parseIndex(in, header);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
        return bamIndex;
    }

    public BamIndex(SamHeader header, List<ReferenceIndex> indexes) {
        this(header, indexes, null);
    }

    public BamIndex(SamHeader header, List<ReferenceIndex> indexes, Long totalNumberOfUnmappedReads) {
        int refIndex = 0;
        Collection<SamReferenceSequence> referenceSequences = header.getReferenceSequences();
        this.indexOfRefNames = new HashMap<String, Integer>(MapUtil.computeMinHashMapSizeWithoutRehashing(referenceSequences.size()));
        for (SamReferenceSequence ref : referenceSequences) {
            this.indexOfRefNames.put(ref.getName(), refIndex);
            ++refIndex;
        }
        this.indexes = new ArrayList<ReferenceIndex>(indexes);
        this.totalNumberOfUnmappedReads = totalNumberOfUnmappedReads;
    }

    public ReferenceIndex getReferenceIndex(int i) {
        return this.indexes.get(i);
    }

    public Integer getReferenceIndexOffset(String refName) {
        if (refName == null) {
            throw new NullPointerException("refName can not be null");
        }
        return this.indexOfRefNames.get(refName);
    }

    public int getNumberOfReferenceIndexes() {
        return this.indexes.size();
    }

    public ReferenceIndex getReferenceIndex(String refName) {
        Integer i = this.getReferenceIndexOffset(refName);
        if (i == null) {
            return null;
        }
        return this.indexes.get(i);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.indexOfRefNames.hashCode();
        result = 31 * result + this.indexes.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BamIndex)) {
            return false;
        }
        BamIndex other = (BamIndex)obj;
        if (!this.indexOfRefNames.equals(other.indexOfRefNames)) {
            return false;
        }
        return this.indexes.equals(other.indexes);
    }

    public Long getTotalNumberOfUnmappedReads() {
        return this.totalNumberOfUnmappedReads;
    }

    private static class SamHeaderParser
    extends AbstractSamVisitor {
        private SamHeader header;

        private SamHeaderParser() {
        }

        @Override
        public void visitHeader(SamVisitor.SamVisitorCallback callback, SamHeader header) {
            this.header = header;
            callback.haltParsing();
        }

        public SamHeader getHeader() {
            return this.header;
        }
    }
}

