/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.header;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SamVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)$");
    private final int major;
    private final int minor;

    public SamVersion(int major, int minor) {
        if (major < 0) {
            throw new IllegalArgumentException("major version number must be >=0");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("minor version number must be >=0");
        }
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean isBefore(SamVersion other) {
        if (other.getMajor() > this.major) {
            return true;
        }
        if (other.getMajor() < this.major) {
            return false;
        }
        return other.minor > this.minor;
    }

    public boolean isAfter(SamVersion other) {
        if (other.getMajor() < this.major) {
            return true;
        }
        if (other.getMajor() > this.major) {
            return false;
        }
        return other.minor < this.minor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SamVersion)) {
            return false;
        }
        SamVersion other = (SamVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public String toString() {
        return String.format("%d.%d", this.major, this.minor);
    }

    public static SamVersion parseVersion(String versionStr) {
        if (versionStr == null) {
            throw new NullPointerException("version string can not be null");
        }
        Matcher matcher = VERSION_PATTERN.matcher(versionStr);
        if (matcher.matches()) {
            return new SamVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
        }
        return null;
    }
}

