/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.header;

import org.jcvi.jillion.sam.header.SamReferenceSequence;

public final class SamReferenceSequenceBuilder {
    String name;
    int length;
    String genomeAssemblyId;
    String species;
    String uri;
    String md5;

    public SamReferenceSequenceBuilder(String name, int length) {
        if (name == null) {
            throw new NullPointerException("name can not be null");
        }
        if (length < 1) {
            throw new IllegalArgumentException("length must >=1");
        }
        this.name = name;
        this.length = length;
    }

    public SamReferenceSequenceBuilder(SamReferenceSequence copy) {
        this.name = copy.getName();
        this.length = copy.getLength();
        this.genomeAssemblyId = copy.getGenomeAssemblyId();
        this.species = copy.getSpecies();
        this.uri = copy.getUri();
        this.md5 = copy.getMd5();
    }

    public SamReferenceSequenceBuilder setName(String name) {
        if (name == null) {
            throw new NullPointerException("name can not be null");
        }
        this.name = name;
        return this;
    }

    public SamReferenceSequenceBuilder setLength(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must >=1");
        }
        this.length = length;
        return this;
    }

    public String getGenomeAssemblyId() {
        return this.genomeAssemblyId;
    }

    public SamReferenceSequenceBuilder setGenomeAssemblyId(String genomeAssemblyId) {
        this.genomeAssemblyId = genomeAssemblyId;
        return this;
    }

    public String getSpecies() {
        return this.species;
    }

    public SamReferenceSequenceBuilder setSpecies(String species) {
        this.species = species;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public SamReferenceSequenceBuilder setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getMd5() {
        return this.md5;
    }

    public SamReferenceSequenceBuilder setMd5(String md5) {
        this.md5 = md5;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public SamReferenceSequenceImpl build() {
        return new SamReferenceSequenceImpl(this);
    }

    private static class SamReferenceSequenceImpl
    implements SamReferenceSequence {
        private final String name;
        private final int length;
        private final String genomeAssemblyId;
        private final String species;
        private final String uri;
        private final String md5;

        SamReferenceSequenceImpl(SamReferenceSequenceBuilder builder) {
            this.name = builder.name;
            this.length = builder.length;
            this.genomeAssemblyId = builder.genomeAssemblyId;
            this.species = builder.species;
            this.uri = builder.uri;
            this.md5 = builder.md5;
        }

        public String toString() {
            return "ReferenceSequence [name=" + this.name + ", length=" + this.length + ", genomeAssemblyId=" + this.genomeAssemblyId + ", species=" + this.species + ", uri=" + this.uri + ", md5=" + this.md5 + "]";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public String getGenomeAssemblyId() {
            return this.genomeAssemblyId;
        }

        @Override
        public String getSpecies() {
            return this.species;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        @Override
        public String getMd5() {
            return this.md5;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.length;
            result = 31 * result + (this.genomeAssemblyId == null ? 0 : this.genomeAssemblyId.hashCode());
            result = 31 * result + (this.md5 == null ? 0 : this.md5.hashCode());
            result = 31 * result + (this.species == null ? 0 : this.species.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SamReferenceSequence)) {
                return false;
            }
            SamReferenceSequence other = (SamReferenceSequence)obj;
            if (!this.name.equals(other.getName())) {
                return false;
            }
            if (this.length != other.getLength()) {
                return false;
            }
            if (this.genomeAssemblyId == null ? other.getGenomeAssemblyId() != null : !this.genomeAssemblyId.equals(other.getGenomeAssemblyId())) {
                return false;
            }
            if (this.md5 == null ? other.getMd5() != null : !this.md5.equals(other.getMd5())) {
                return false;
            }
            if (this.species == null ? other.getSpecies() != null : !this.species.equals(other.getSpecies())) {
                return false;
            }
            return !(this.uri == null ? other.getUri() != null : !this.uri.equals(other.getUri()));
        }
    }
}

