/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.header;

import java.util.Date;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.sam.header.SamReadGroup;

public class SamReadGroupBuilder {
    private String id;
    private String sequencingCenter;
    private String description;
    private String library;
    private String programsUsed;
    private String platformUnit;
    private String sampleOrPoolName;
    private Integer predictedInsertSize;
    private SamReadGroup.PlatformTechnology platform;
    private Long datetime;
    private NucleotideSequence keySequence;
    private NucleotideSequence flowOrder;

    public SamReadGroupBuilder(String id) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        this.id = id;
    }

    public SamReadGroupBuilder(SamReadGroup copy) {
        this.id = copy.getId();
        this.sequencingCenter = copy.getSequencingCenter();
        this.description = copy.getDescription();
        this.library = copy.getLibrary();
        this.programsUsed = copy.getPrograms();
        this.platformUnit = copy.getPlatformUnit();
        this.sampleOrPoolName = copy.getSampleOrPoolName();
        this.predictedInsertSize = copy.getPredictedInsertSize();
        this.platform = copy.getPlatform();
        this.datetime = copy.getRunDate().getTime();
        this.keySequence = copy.getKeySequence();
        this.flowOrder = copy.getFlowOrder();
    }

    public NucleotideSequence getKeySequence() {
        return this.keySequence;
    }

    public SamReadGroupBuilder setKeySequence(NucleotideSequence keySequence) {
        this.keySequence = keySequence;
        return this;
    }

    public NucleotideSequence getFlowOrder() {
        return this.flowOrder;
    }

    public SamReadGroupBuilder setFlowOrder(NucleotideSequence flowOrder) {
        this.flowOrder = flowOrder;
        return this;
    }

    public Integer getPredictedInsertSize() {
        return this.predictedInsertSize;
    }

    public SamReadGroupBuilder setPredictedInsertSize(Integer predictedInsertSize) {
        this.predictedInsertSize = predictedInsertSize;
        return this;
    }

    public SamReadGroup.PlatformTechnology getPlatform() {
        return this.platform;
    }

    public SamReadGroupBuilder setPlatform(SamReadGroup.PlatformTechnology platform) {
        this.platform = platform;
        return this;
    }

    public String getSampleOrPoolName() {
        return this.sampleOrPoolName;
    }

    public SamReadGroupBuilder setSampleOrPoolName(String sampleOrPoolName) {
        this.sampleOrPoolName = sampleOrPoolName;
        return this;
    }

    public String getSequencingCenter() {
        return this.sequencingCenter;
    }

    public SamReadGroupBuilder setSequencingCenter(String name) {
        this.sequencingCenter = name;
        return this;
    }

    public Date getRunDate() {
        if (this.datetime == null) {
            return null;
        }
        return new Date(this.datetime);
    }

    public SamReadGroupBuilder setRunDate(Date date) {
        this.datetime = date == null ? null : Long.valueOf(date.getTime());
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SamReadGroupBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getLibrary() {
        return this.library;
    }

    public SamReadGroupBuilder setLibrary(String library) {
        this.library = library;
        return this;
    }

    public String getPrograms() {
        return this.programsUsed;
    }

    public SamReadGroupBuilder setPrograms(String programs) {
        this.programsUsed = programs;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SamReadGroupBuilder setId(String newId) {
        if (newId == null) {
            throw new NullPointerException("new id can not be null");
        }
        this.id = newId;
        return this;
    }

    public String getPlatformUnit() {
        return this.platformUnit;
    }

    public SamReadGroupBuilder setPlatformUnit(String platformUnit) {
        this.platformUnit = platformUnit;
        return this;
    }

    public SamReadGroupImpl build() {
        return new SamReadGroupImpl(this);
    }

    private static final class SamReadGroupImpl
    implements SamReadGroup {
        final String id;
        final String sequencingCenter;
        final String description;
        final String library;
        final String programs;
        final String platformUnit;
        final String sampleOrPoolName;
        private final Integer predictedMedianInsertSize;
        final SamReadGroup.PlatformTechnology platform;
        final Long datetime;
        final NucleotideSequence keySequence;
        final NucleotideSequence flowOrder;

        SamReadGroupImpl(SamReadGroupBuilder builder) {
            this.id = builder.id;
            this.sequencingCenter = builder.sequencingCenter;
            this.description = builder.description;
            this.library = builder.library;
            this.programs = builder.programsUsed;
            this.platformUnit = builder.platformUnit;
            this.sampleOrPoolName = builder.sampleOrPoolName;
            this.predictedMedianInsertSize = builder.predictedInsertSize;
            this.platform = builder.platform;
            this.datetime = builder.datetime;
            this.keySequence = builder.keySequence;
            this.flowOrder = builder.flowOrder;
        }

        @Override
        public Integer getPredictedInsertSize() {
            return this.predictedMedianInsertSize;
        }

        @Override
        public SamReadGroup.PlatformTechnology getPlatform() {
            return this.platform;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getPlatformUnit() {
            return this.platformUnit;
        }

        @Override
        public NucleotideSequence getKeySequence() {
            return this.keySequence;
        }

        @Override
        public NucleotideSequence getFlowOrder() {
            return this.flowOrder;
        }

        @Override
        public String getSequencingCenter() {
            return this.sequencingCenter;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getLibrary() {
            return this.library;
        }

        @Override
        public String getPrograms() {
            return this.programs;
        }

        @Override
        public String getSampleOrPoolName() {
            return this.sampleOrPoolName;
        }

        @Override
        public Date getRunDate() {
            if (this.datetime == null) {
                return null;
            }
            return new Date(this.datetime);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id.hashCode();
            result = 31 * result + (this.datetime == null ? 0 : this.datetime.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.flowOrder == null ? 0 : this.flowOrder.hashCode());
            result = 31 * result + (this.keySequence == null ? 0 : this.keySequence.hashCode());
            result = 31 * result + (this.library == null ? 0 : this.library.hashCode());
            result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
            result = 31 * result + (this.platformUnit == null ? 0 : this.platformUnit.hashCode());
            result = 31 * result + (this.predictedMedianInsertSize == null ? 0 : this.predictedMedianInsertSize.hashCode());
            result = 31 * result + (this.programs == null ? 0 : this.programs.hashCode());
            result = 31 * result + (this.sampleOrPoolName == null ? 0 : this.sampleOrPoolName.hashCode());
            result = 31 * result + (this.sequencingCenter == null ? 0 : this.sequencingCenter.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SamReadGroup)) {
                return false;
            }
            SamReadGroup other = (SamReadGroup)obj;
            if (!this.id.equals(other.getId())) {
                return false;
            }
            if (this.datetime == null) {
                if (other.getRunDate() != null) {
                    return false;
                }
            } else {
                if (other.getRunDate() == null) {
                    return false;
                }
                if (!this.datetime.equals(other.getRunDate().getTime())) {
                    return false;
                }
            }
            if (this.description == null ? other.getDescription() != null : !this.description.equals(other.getDescription())) {
                return false;
            }
            if (this.flowOrder == null ? other.getFlowOrder() != null : !this.flowOrder.equals(other.getFlowOrder())) {
                return false;
            }
            if (this.keySequence == null ? other.getKeySequence() != null : !this.keySequence.equals(other.getKeySequence())) {
                return false;
            }
            if (this.library == null ? other.getLibrary() != null : !this.library.equals(other.getLibrary())) {
                return false;
            }
            if (this.platform != other.getPlatform()) {
                return false;
            }
            if (this.platformUnit == null ? other.getPlatformUnit() != null : !this.platformUnit.equals(other.getPlatformUnit())) {
                return false;
            }
            if (this.predictedMedianInsertSize == null ? other.getPredictedInsertSize() != null : !this.predictedMedianInsertSize.equals(other.getPredictedInsertSize())) {
                return false;
            }
            if (this.programs == null ? other.getPrograms() != null : !this.programs.equals(other.getPrograms())) {
                return false;
            }
            if (this.sampleOrPoolName == null ? other.getSampleOrPoolName() != null : !this.sampleOrPoolName.equals(other.getSampleOrPoolName())) {
                return false;
            }
            return !(this.sequencingCenter == null ? other.getSequencingCenter() != null : !this.sequencingCenter.equals(other.getSequencingCenter()));
        }
    }
}

