/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.header;

import org.jcvi.jillion.sam.header.SamProgram;

public final class SamProgramBuilder {
    private String id;
    private String name;
    private String version;
    private String description;
    private String commandLine;
    private String prevousProgramId;

    public SamProgramBuilder(String id) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        this.id = id;
    }

    public SamProgramBuilder(SamProgram copy) {
        this.id = copy.getId();
        this.name = copy.getName();
        this.version = copy.getVersion();
        this.description = copy.getDescription();
        this.prevousProgramId = copy.getPreviousProgramId();
        this.commandLine = copy.getCommandLine();
    }

    public String getName() {
        return this.name;
    }

    public SamProgramBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public SamProgramBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SamProgramBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public SamProgramBuilder setCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    public String getPrevousProgramId() {
        return this.prevousProgramId;
    }

    public SamProgramBuilder setPrevousProgramId(String prevousProgramId) {
        this.prevousProgramId = prevousProgramId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SamProgramBuilder setId(String newId) {
        if (newId == null) {
            throw new NullPointerException("new id can not be null");
        }
        this.id = newId;
        return this;
    }

    public SamProgramImpl build() {
        return new SamProgramImpl(this);
    }

    private static final class SamProgramImpl
    implements SamProgram {
        private final String id;
        private final String name;
        private final String version;
        private final String description;
        private final String commandLine;
        private final String previousProgramid;

        SamProgramImpl(SamProgramBuilder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this.version = builder.version;
            this.description = builder.description;
            this.commandLine = builder.commandLine;
            this.previousProgramid = builder.prevousProgramId;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getCommandLine() {
            return this.commandLine;
        }

        @Override
        public String getPreviousProgramId() {
            return this.previousProgramid;
        }

        public String toString() {
            return "SamProgram [id=" + this.id + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", commandLine=" + this.commandLine + ", previousProgramid=" + this.previousProgramid + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.commandLine == null ? 0 : this.commandLine.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.previousProgramid == null ? 0 : this.previousProgramid.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SamProgram)) {
                return false;
            }
            SamProgram other = (SamProgram)obj;
            if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
                return false;
            }
            if (this.commandLine == null ? other.getCommandLine() != null : !this.commandLine.equals(other.getCommandLine())) {
                return false;
            }
            if (this.description == null ? other.getDescription() != null : !this.description.equals(other.getDescription())) {
                return false;
            }
            if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
                return false;
            }
            if (this.previousProgramid == null ? other.getPreviousProgramId() != null : !this.previousProgramid.equals(other.getPreviousProgramId())) {
                return false;
            }
            return !(this.version == null ? other.getVersion() != null : !this.version.equals(other.getVersion()));
        }
    }
}

