/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.header;

import org.jcvi.jillion.internal.sam.SamUtil;

public final class SamHeaderTagKey {
    private static final SamHeaderTagKey[][] CACHE = new SamHeaderTagKey[122][122];
    private final char key1;
    private final char key2;

    SamHeaderTagKey(char key1, char key2) {
        if (!SamUtil.isValidKey(key1, key2)) {
            throw new IllegalArgumentException("invalid key " + key1 + key2);
        }
        this.key1 = key1;
        this.key2 = key2;
    }

    public static SamHeaderTagKey getKey(String key) {
        if (key.length() != 2) {
            throw new IllegalArgumentException("key string must be 2 chars long " + key);
        }
        return SamHeaderTagKey.getKey(key.charAt(0), key.charAt(1));
    }

    public static SamHeaderTagKey getKey(char first, char second) {
        SamHeaderTagKey.assertValidRange(first);
        SamHeaderTagKey.assertValidRange(second);
        SamHeaderTagKey key = CACHE[first][second];
        if (key == null) {
            SamHeaderTagKey.CACHE[first][second] = key = new SamHeaderTagKey(first, second);
        }
        return key;
    }

    private static void assertValidRange(char c) {
        if (c >= CACHE.length) {
            throw new IllegalArgumentException("invalid char codepoint: " + c);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key1;
        result = 31 * result + this.key2;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SamHeaderTagKey other = (SamHeaderTagKey)obj;
        if (this.key1 != other.key1) {
            return false;
        }
        return this.key2 == other.key2;
    }

    public String toString() {
        return new StringBuilder(2).append(this.key1).append(this.key2).toString();
    }

    public char getFirstChar() {
        return this.key1;
    }

    public char getSecondChar() {
        return this.key2;
    }
}

