/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.header;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamValidationException;
import org.jcvi.jillion.sam.SortOrder;
import org.jcvi.jillion.sam.attribute.SamAttribute;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamProgram;
import org.jcvi.jillion.sam.header.SamReadGroup;
import org.jcvi.jillion.sam.header.SamReferenceSequence;
import org.jcvi.jillion.sam.header.SamVersion;

public final class SamHeaderBuilder {
    private SortOrder sortOrder = SortOrder.UNKNOWN;
    private SamVersion version;
    private final Map<String, SamReferenceSequence> referenceSequences = new LinkedHashMap<String, SamReferenceSequence>();
    private final Map<String, SamReadGroup> readGroups = new HashMap<String, SamReadGroup>();
    private final Map<String, SamProgram> programs = new HashMap<String, SamProgram>();
    private final List<String> comments = new ArrayList<String>();

    public SamHeaderBuilder() {
    }

    public SamHeaderBuilder(SamHeader copy) {
        this.sortOrder = copy.getSortOrder();
        this.version = copy.getVersion();
        for (SamReferenceSequence ref : copy.getReferenceSequences()) {
            this.referenceSequences.put(ref.getName(), ref);
        }
        for (SamReadGroup readGroup : copy.getReadGroups()) {
            this.readGroups.put(readGroup.getId(), readGroup);
        }
        for (SamProgram prog : copy.getPrograms()) {
            this.programs.put(prog.getId(), prog);
        }
        this.comments.addAll(copy.getComments());
    }

    public SamHeaderBuilder setVersion(SamVersion version) {
        this.version = version;
        return this;
    }

    public SamHeaderBuilder addReferenceSequence(SamReferenceSequence refSeq) {
        if (refSeq == null) {
            throw new NullPointerException("reference sequence can not be null");
        }
        if (this.referenceSequences.containsKey(refSeq.getName())) {
            throw new IllegalArgumentException("reference sequence with same name already in header : " + refSeq.getName());
        }
        this.referenceSequences.put(refSeq.getName(), refSeq);
        return this;
    }

    public SamHeaderBuilder addReadGroup(SamReadGroup readGroup) {
        if (readGroup == null) {
            throw new NullPointerException("read group can not be null");
        }
        if (this.readGroups.containsKey(readGroup.getId())) {
            throw new IllegalArgumentException("read group with same id already in header : " + readGroup.getId());
        }
        this.readGroups.put(readGroup.getId(), readGroup);
        return this;
    }

    public SamHeaderBuilder addProgram(SamProgram program) {
        if (program == null) {
            throw new NullPointerException("program can not be null");
        }
        if (this.programs.containsKey(program.getId())) {
            throw new IllegalArgumentException("program with same id already in header : " + program.getId());
        }
        this.programs.put(program.getId(), program);
        return this;
    }

    public SamHeaderBuilder addComment(String commentLine) {
        if (commentLine == null) {
            throw new NullPointerException("commentLine can not be null");
        }
        this.comments.add(commentLine);
        return this;
    }

    public SamHeaderBuilder setSortOrder(SortOrder order) {
        this.sortOrder = order == null ? SortOrder.UNKNOWN : order;
        return this;
    }

    public SamHeader build() {
        for (SamProgram program : this.programs.values()) {
            String prevId = program.getPreviousProgramId();
            if (prevId == null || this.programs.containsKey(prevId)) continue;
            throw new IllegalStateException("known previous program " + prevId + "referenced in " + program.getId());
        }
        return new SamHeaderImpl(this);
    }

    public boolean hasReferenceSequence(String name) {
        return this.referenceSequences.containsKey(name);
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    private static final class SamHeaderImpl
    implements SamHeader {
        private final SortOrder sortOrder;
        private final SamVersion version;
        private final Map<String, SamReferenceSequence> referenceSequences;
        private final Map<String, Integer> referenceIndexMap;
        private final SamReferenceSequence[] indexedReferenceSequences;
        private final Map<String, SamReadGroup> readGroups;
        private final Map<String, SamProgram> programs;
        private final List<String> comments;

        SamHeaderImpl(SamHeaderBuilder builder) {
            this.sortOrder = builder.sortOrder;
            this.version = builder.version;
            this.referenceSequences = Collections.unmodifiableMap(new LinkedHashMap(builder.referenceSequences));
            this.readGroups = Collections.unmodifiableMap(new HashMap(builder.readGroups));
            this.programs = Collections.unmodifiableMap(new HashMap(builder.programs));
            this.comments = Collections.unmodifiableList(new ArrayList(builder.comments));
            this.referenceIndexMap = new LinkedHashMap<String, Integer>();
            int i = 0;
            Collection<SamReferenceSequence> refSeqs = this.referenceSequences.values();
            this.indexedReferenceSequences = new SamReferenceSequence[refSeqs.size()];
            Iterator<SamReferenceSequence> iterator = refSeqs.iterator();
            while (iterator.hasNext()) {
                SamReferenceSequence refSeq;
                this.indexedReferenceSequences[i] = refSeq = iterator.next();
                this.referenceIndexMap.put(refSeq.getName(), i);
                ++i;
            }
        }

        public String toString() {
            return "SamHeader [sortOrder=" + (Object)((Object)this.sortOrder) + ", version=" + this.version + ", referenceSequences=" + this.referenceSequences + ", referenceIndexMap=" + this.referenceIndexMap + ", readGroups=" + this.readGroups + ", programs=" + this.programs + ", comments=" + this.comments + "]";
        }

        @Override
        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public SamVersion getVersion() {
            return this.version;
        }

        @Override
        public SamReferenceSequence getReferenceSequence(String name) {
            return this.referenceSequences.get(name);
        }

        @Override
        public SamProgram getSamProgram(String id) {
            return this.programs.get(id);
        }

        @Override
        public SamReadGroup getReadGroup(String id) {
            return this.readGroups.get(id);
        }

        @Override
        public Collection<SamReadGroup> getReadGroups() {
            return this.readGroups.values();
        }

        @Override
        public Collection<SamProgram> getPrograms() {
            return this.programs.values();
        }

        @Override
        public Collection<SamReferenceSequence> getReferenceSequences() {
            return this.referenceSequences.values();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.comments.hashCode();
            result = 31 * result + this.programs.hashCode();
            result = 31 * result + this.readGroups.hashCode();
            result = 31 * result + this.referenceSequences.hashCode();
            result = 31 * result + this.sortOrder.hashCode();
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        private <T> boolean collectionMatch(Iterable<T> expected, Iterable<T> actual) {
            Iterator<T> expectedIter = expected.iterator();
            Iterator<T> actualIter = actual.iterator();
            while (expectedIter.hasNext()) {
                if (!actualIter.hasNext()) {
                    return false;
                }
                if (expectedIter.next().equals(actualIter.next())) continue;
                return false;
            }
            return !actualIter.hasNext();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SamHeader)) {
                return false;
            }
            SamHeader other = (SamHeader)obj;
            if (!this.comments.equals(other.getComments())) {
                return false;
            }
            if (!this.collectionMatch(this.programs.values(), other.getPrograms())) {
                return false;
            }
            if (!this.collectionMatch(this.readGroups.values(), other.getReadGroups())) {
                return false;
            }
            if (!this.collectionMatch(this.referenceSequences.values(), other.getReferenceSequences())) {
                return false;
            }
            if (this.sortOrder != other.getSortOrder()) {
                return false;
            }
            return !(this.version == null ? other.getVersion() != null : !this.version.equals(other.getVersion()));
        }

        @Override
        public List<String> getComments() {
            return this.comments;
        }

        @Override
        public void validateRecord(SamRecord record, SamAttributeValidator attributeValidator) throws SamValidationException {
            String refName = record.getReferenceName();
            if (refName != null && this.getReferenceSequence(refName) == null) {
                throw new SamValidationException("unknown reference " + refName);
            }
            String nextRefName = record.getNextName();
            if (nextRefName != null && !"=".equals(nextRefName) && this.getReferenceSequence(nextRefName) == null) {
                throw new SamValidationException("unknown next reference " + nextRefName);
            }
            for (SamAttribute attribute : record.getAttributes()) {
                attributeValidator.validate(this, record, attribute);
            }
        }
    }
}

