/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.cigar;

public enum CigarOperation {
    ALIGNMENT_MATCH('M'),
    INSERTION('I'),
    DELETION('D'),
    SKIPPED('N'),
    SOFT_CLIP('S'),
    HARD_CLIP('H'),
    PADDING('P'),
    SEQUENCE_MATCH('='),
    SEQUENCE_MISMATCH('X');

    private static final CigarOperation[] VALUES;
    private static final CigarOperation[] SAM_CHARS;
    private final char opCode;

    private CigarOperation(char opCode) {
        this.opCode = opCode;
    }

    public char getOpCode() {
        return this.opCode;
    }

    public int getBinaryOpCode() {
        return this.ordinal();
    }

    public static CigarOperation parseBinary(int bit) {
        return VALUES[bit];
    }

    public static CigarOperation parseOp(String op) {
        return CigarOperation.parseOp(op.charAt(0));
    }

    public static CigarOperation parseOp(char op) {
        CigarOperation cigarOperation;
        int offset = op - 61;
        if (offset >= 0 && offset < SAM_CHARS.length && (cigarOperation = SAM_CHARS[offset]) != null) {
            return cigarOperation;
        }
        throw new IllegalArgumentException("invalid cigar opcode : " + op);
    }

    static {
        VALUES = CigarOperation.values();
        SAM_CHARS = new CigarOperation[28];
        for (int i = 0; i < VALUES.length; ++i) {
            CigarOperation cigarOperation = VALUES[i];
            char opCode = cigarOperation.opCode;
            int offset = opCode - 61;
            CigarOperation.SAM_CHARS[offset] = cigarOperation;
        }
    }
}

