/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.cigar;

import org.jcvi.jillion.sam.cigar.CigarOperation;

public final class CigarElement {
    private final int length;
    private final CigarOperation op;

    public CigarElement(CigarOperation op, int length) {
        if (op == null) {
            throw new NullPointerException("cigar op can not be null");
        }
        if (length < 1) {
            throw new IllegalArgumentException("length can < 1");
        }
        this.op = op;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public CigarOperation getOp() {
        return this.op;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.op.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CigarElement)) {
            return false;
        }
        CigarElement other = (CigarElement)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.op == other.op;
    }
}

