/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.cigar;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jcvi.jillion.align.pairwise.PairwiseSequenceAlignment;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.iter.ArrayIterator;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.sam.cigar.CigarElement;
import org.jcvi.jillion.sam.cigar.CigarOperation;

public final class Cigar
implements Iterable<CigarElement> {
    private static Pattern REMOVE_WHITESPACE = Pattern.compile("\\s+");
    public static final Cigar EMPTY_CIGAR = new Builder(0).build();
    private static final String UN_AVAILABLE = "*";
    private final CigarElement[] elements;

    public static Cigar parse(String cigarString) {
        String trimmedString = REMOVE_WHITESPACE.matcher(cigarString).replaceAll("");
        if (trimmedString.isEmpty()) {
            throw new IllegalArgumentException("cigar string can not be null");
        }
        if (trimmedString.equals(UN_AVAILABLE)) {
            return null;
        }
        Builder builder = new Builder();
        PrimitiveCharIterator iter = new PrimitiveCharIterator(trimmedString);
        while (iter.hasNext()) {
            char next;
            int length = 0;
            while (Cigar.isDigit(next = iter.next())) {
                length = length * 10 + (next - 48);
            }
            if (length == 0) {
                throw new IllegalArgumentException("invalid cigar string " + cigarString);
            }
            CigarOperation op = CigarOperation.parseOp(next);
            builder.addElement(new CigarElement(op, length));
        }
        return builder.build();
    }

    public static <R extends Residue, S extends ResidueSequence<R, S, ?>> Cigar createFrom(PairwiseSequenceAlignment<R, S> alignment) {
        Object query = alignment.getGappedQueryAlignment();
        Object subject = alignment.getGappedSubjectAlignment();
        Builder builder = new Builder();
        Iterator queryIter = query.iterator();
        Iterator subjectIter = subject.iterator();
        int softClipLength = (int)alignment.getQueryRange().getBegin();
        if (softClipLength > 0) {
            builder.addElement(CigarOperation.SOFT_CLIP, softClipLength);
        }
        int currentLength = 0;
        CigarOperation currentOp = null;
        while (queryIter.hasNext()) {
            Residue q = (Residue)queryIter.next();
            Residue s = (Residue)subjectIter.next();
            CigarOperation thisOp = q.isGap() ? (s.isGap() ? CigarOperation.PADDING : CigarOperation.DELETION) : (s.isGap() ? CigarOperation.INSERTION : CigarOperation.ALIGNMENT_MATCH);
            if (thisOp != currentOp) {
                if (currentOp != null) {
                    builder.addElement(new CigarElement(currentOp, currentLength));
                }
                currentOp = thisOp;
                currentLength = 1;
                continue;
            }
            ++currentLength;
        }
        if (currentOp != null) {
            builder.addElement(new CigarElement(currentOp, currentLength));
        }
        return builder.build();
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private Cigar(CigarElement[] elements) {
        this.elements = elements;
    }

    @Override
    public Iterator<CigarElement> iterator() {
        return new ArrayIterator<CigarElement>(this.elements);
    }

    public int getPaddedReadLength(ClipType type) {
        switch (type) {
            case RAW: {
                return this.getRawPaddedReadLength();
            }
            case SOFT_CLIPPED: {
                return this.getPaddedReadLength();
            }
            case HARD_CLIPPED: {
                return this.getSoftPaddedReadLength();
            }
        }
        throw new IllegalArgumentException("unknown clip type : " + (Object)((Object)type));
    }

    public int getUnpaddedReadLength(ClipType type) {
        switch (type) {
            case RAW: {
                return this.getRawUnPaddedReadLength();
            }
            case SOFT_CLIPPED: {
                return this.getUnPaddedReadLength();
            }
            case HARD_CLIPPED: {
                return this.getSoftUnPaddedReadLength();
            }
        }
        throw new IllegalArgumentException("unknown clip type : " + (Object)((Object)type));
    }

    private int getRawUnPaddedReadLength() {
        int length = 0;
        block11: for (CigarElement element : this.elements) {
            switch (element.getOp()) {
                case ALIGNMENT_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case INSERTION: {
                    length += element.getLength();
                    continue block11;
                }
                case DELETION: {
                    continue block11;
                }
                case SKIPPED: {
                    continue block11;
                }
                case SOFT_CLIP: {
                    length += element.getLength();
                    continue block11;
                }
                case HARD_CLIP: {
                    length += element.getLength();
                    continue block11;
                }
                case PADDING: {
                    continue block11;
                }
                case SEQUENCE_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MISMATCH: {
                    length += element.getLength();
                    continue block11;
                }
            }
        }
        return length;
    }

    private int getRawPaddedReadLength() {
        int length = 0;
        block11: for (CigarElement element : this.elements) {
            switch (element.getOp()) {
                case ALIGNMENT_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case INSERTION: {
                    length += element.getLength();
                    continue block11;
                }
                case DELETION: {
                    length += element.getLength();
                    continue block11;
                }
                case SKIPPED: {
                    continue block11;
                }
                case SOFT_CLIP: {
                    length += element.getLength();
                    continue block11;
                }
                case HARD_CLIP: {
                    length += element.getLength();
                    continue block11;
                }
                case PADDING: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MISMATCH: {
                    length += element.getLength();
                    continue block11;
                }
            }
        }
        return length;
    }

    private int getSoftPaddedReadLength() {
        int length = 0;
        block11: for (CigarElement element : this.elements) {
            switch (element.getOp()) {
                case ALIGNMENT_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case INSERTION: {
                    length += element.getLength();
                    continue block11;
                }
                case DELETION: {
                    length += element.getLength();
                    continue block11;
                }
                case SKIPPED: {
                    continue block11;
                }
                case SOFT_CLIP: {
                    length += element.getLength();
                    continue block11;
                }
                case HARD_CLIP: {
                    continue block11;
                }
                case PADDING: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MISMATCH: {
                    length += element.getLength();
                    continue block11;
                }
            }
        }
        return length;
    }

    public int getUnPaddedReadLength() {
        int length = 0;
        block11: for (CigarElement element : this.elements) {
            switch (element.getOp()) {
                case ALIGNMENT_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case INSERTION: {
                    length += element.getLength();
                    continue block11;
                }
                case DELETION: {
                    continue block11;
                }
                case SKIPPED: {
                    continue block11;
                }
                case SOFT_CLIP: {
                    continue block11;
                }
                case HARD_CLIP: {
                    continue block11;
                }
                case PADDING: {
                    continue block11;
                }
                case SEQUENCE_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MISMATCH: {
                    length += element.getLength();
                    continue block11;
                }
            }
        }
        return length;
    }

    private int getSoftUnPaddedReadLength() {
        int length = 0;
        block11: for (CigarElement element : this.elements) {
            switch (element.getOp()) {
                case ALIGNMENT_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case INSERTION: {
                    length += element.getLength();
                    continue block11;
                }
                case DELETION: {
                    continue block11;
                }
                case SKIPPED: {
                    continue block11;
                }
                case SOFT_CLIP: {
                    length += element.getLength();
                    continue block11;
                }
                case HARD_CLIP: {
                    continue block11;
                }
                case PADDING: {
                    continue block11;
                }
                case SEQUENCE_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MISMATCH: {
                    length += element.getLength();
                    continue block11;
                }
            }
        }
        return length;
    }

    private int getPaddedReadLength() {
        int length = 0;
        block11: for (CigarElement element : this.elements) {
            switch (element.getOp()) {
                case ALIGNMENT_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case INSERTION: {
                    length += element.getLength();
                    continue block11;
                }
                case DELETION: {
                    length += element.getLength();
                    continue block11;
                }
                case SKIPPED: {
                    continue block11;
                }
                case SOFT_CLIP: {
                    continue block11;
                }
                case HARD_CLIP: {
                    continue block11;
                }
                case PADDING: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MISMATCH: {
                    length += element.getLength();
                    continue block11;
                }
            }
        }
        return length;
    }

    public int getNumberOfElements() {
        return this.elements.length;
    }

    public CigarElement getElement(int i) {
        return this.elements[i];
    }

    public Iterator<CigarElement> getElementIterator() {
        return IteratorUtil.createIteratorFromArray(this.elements);
    }

    public NucleotideSequence toGappedTrimmedSequence(NucleotideSequence rawUngappedSequence) {
        return this.toGappedTrimmedSequenceBuilder(rawUngappedSequence).build();
    }

    public String toString() {
        return this.toCigarString();
    }

    public String toCigarString() {
        StringBuilder builder = new StringBuilder(3 * this.elements.length);
        for (CigarElement e : this.elements) {
            builder.append(e.getLength()).append(e.getOp().getOpCode());
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.elements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cigar)) {
            return false;
        }
        Cigar other = (Cigar)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public Range getValidRange() {
        int ungappedAlignedLength = this.getUnPaddedReadLength();
        int numberOfClippedLeadingBases = this.computeLeadingClippedBases();
        return new Range.Builder(ungappedAlignedLength).shift(numberOfClippedLeadingBases).build();
    }

    private int computeLeadingClippedBases() {
        int count = 0;
        for (CigarElement e : this.elements) {
            if (e.getOp() != CigarOperation.HARD_CLIP && e.getOp() != CigarOperation.SOFT_CLIP) break;
            count += e.getLength();
        }
        return count;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public NucleotideSequenceBuilder toGappedTrimmedSequenceBuilder(NucleotideSequence rawUngappedSequence) {
        if (rawUngappedSequence.getNumberOfGaps() != 0) {
            throw new IllegalArgumentException("rawUngapped Sequence can not have gaps");
        }
        NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(rawUngappedSequence);
        int currentOffset = 0;
        int ungappedLength = 0;
        block6: for (CigarElement e : this.elements) {
            switch (e.getOp()) {
                case SOFT_CLIP: 
                case HARD_CLIP: {
                    builder.delete(new Range.Builder(e.getLength()).shift(currentOffset).build());
                    ungappedLength += e.getLength();
                    continue block6;
                }
                case DELETION: {
                    char[] gaps = new char[e.getLength()];
                    Arrays.fill(gaps, '-');
                    builder.insert(currentOffset, gaps);
                    currentOffset += e.getLength();
                    continue block6;
                }
                case PADDING: {
                    continue block6;
                }
                case SKIPPED: {
                    char[] skips = new char[e.getLength()];
                    Arrays.fill(skips, '-');
                    builder.insert(currentOffset, skips);
                    currentOffset += e.getLength();
                    continue block6;
                }
                default: {
                    currentOffset += e.getLength();
                    ungappedLength += e.getLength();
                }
            }
        }
        if ((long)ungappedLength != rawUngappedSequence.getLength()) {
            throw new IllegalArgumentException("invalid input sequence length, expected " + ungappedLength + " but was " + rawUngappedSequence.getLength());
        }
        return builder;
    }

    public int getNumberOfReferenceBasesAligned() {
        int length = 0;
        block11: for (CigarElement element : this.elements) {
            switch (element.getOp()) {
                case ALIGNMENT_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case INSERTION: {
                    continue block11;
                }
                case DELETION: {
                    length += element.getLength();
                    continue block11;
                }
                case SKIPPED: {
                    length += element.getLength();
                    continue block11;
                }
                case SOFT_CLIP: {
                    continue block11;
                }
                case HARD_CLIP: {
                    continue block11;
                }
                case PADDING: {
                    continue block11;
                }
                case SEQUENCE_MATCH: {
                    length += element.getLength();
                    continue block11;
                }
                case SEQUENCE_MISMATCH: {
                    length += element.getLength();
                    continue block11;
                }
            }
        }
        return length;
    }

    private static final class PrimitiveCharIterator {
        private final char[] array;
        private int i = 0;

        public PrimitiveCharIterator(char[] array) {
            this.array = array;
        }

        public PrimitiveCharIterator(String string) {
            this(string.toCharArray());
        }

        public boolean hasNext() {
            return this.i < this.array.length;
        }

        public char next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("no more elements");
            }
            return this.array[this.i++];
        }
    }

    public static class Builder {
        private final List<CigarElement> elements;

        public Builder(int size) {
            this.elements = new ArrayList<CigarElement>(size);
        }

        public Builder() {
            this.elements = new ArrayList<CigarElement>();
        }

        public Builder(Cigar cigar) {
            this.elements = new ArrayList<CigarElement>(cigar.getNumberOfElements());
            for (CigarElement e : cigar) {
                this.elements.add(e);
            }
        }

        public Builder addElement(CigarOperation op, int length) {
            return this.addElement(new CigarElement(op, length));
        }

        public Builder addElement(CigarElement e) {
            if (e == null) {
                throw new NullPointerException("element can not be null");
            }
            this.elements.add(e);
            return this;
        }

        public Cigar build() {
            CigarElement[] array = this.elements.toArray(new CigarElement[this.elements.size()]);
            this.validate(array);
            return new Cigar(array);
        }

        private void validate(CigarElement[] array) {
            for (int i = 0; i < array.length; ++i) {
                int j;
                if (i != 0 && i != array.length - 1 && array[i].getOp() == CigarOperation.HARD_CLIP) {
                    throw new IllegalStateException("hard clips may only be first and/or last operations");
                }
                if (array[i].getOp() != CigarOperation.SOFT_CLIP) continue;
                if (i < array.length / 2) {
                    for (j = 0; j < i; ++j) {
                        if (array[j].getOp() == CigarOperation.HARD_CLIP) continue;
                        throw new IllegalStateException("soft clips may only have hard clips between them and the end of the CIGAR string");
                    }
                    continue;
                }
                for (j = i + 1; j < array.length; ++j) {
                    if (array[j].getOp() == CigarOperation.HARD_CLIP) continue;
                    throw new IllegalStateException("soft clips may only have hard clips between them and the end of the CIGAR string");
                }
            }
        }

        public Builder removeHardClips() {
            int lastIndex = this.elements.size() - 1;
            if (this.elements.get(lastIndex).getOp() == CigarOperation.HARD_CLIP) {
                this.elements.remove(lastIndex);
            }
            if (this.elements.get(0).getOp() == CigarOperation.HARD_CLIP) {
                this.elements.remove(0);
            }
            return this;
        }
    }

    public static enum ClipType {
        RAW,
        SOFT_CLIPPED,
        HARD_CLIPPED;

    }
}

