/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.attribute;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.UnsignedByteArray;
import org.jcvi.jillion.core.util.UnsignedIntArray;
import org.jcvi.jillion.core.util.UnsignedShortArray;
import org.jcvi.jillion.sam.attribute.InvalidValueTypeException;

public enum SamAttributeType {
    PRINTABLE_CHARACTER('A'){

        private boolean assertValidValue(char c) {
            return c >= '!' && c <= '~';
        }

        @Override
        public boolean isPrintableCharacter() {
            return true;
        }

        @Override
        public char getPrintableCharacter(Object obj) {
            return ((Character)obj).charValue();
        }

        @Override
        public String textEncode(Object o) {
            try {
                return ((Character)o).toString();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("not a character", e);
            }
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            out.put((byte)o.toString().charAt(0));
        }

        @Override
        public Object decode(String value) {
            if (value.length() != 1) {
                throw new IllegalArgumentException("length must be 1");
            }
            char firstChar = value.charAt(0);
            if (!this.assertValidValue(firstChar)) {
                throw new IllegalArgumentException("invalid printable char ascii value : " + firstChar);
            }
            return Character.valueOf(firstChar);
        }

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof Character)) {
                throw new InvalidValueTypeException("not a Character");
            }
            if (!this.assertValidValue(((Character)value).charValue())) {
                throw new InvalidValueTypeException("not a valid printable character");
            }
        }
    }
    ,
    SIGNED_INT('i'){

        @Override
        public boolean isSignedInt() {
            return true;
        }

        @Override
        public int getSignedInt(Object obj) {
            return Integer.parseInt(obj.toString());
        }

        @Override
        public String textEncode(Object o) {
            try {
                return Integer.toString(Integer.parseInt(o.toString()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("not an int", e);
            }
        }

        @Override
        public void encodeInBam(Object o, ByteBuffer b) throws IOException {
            int i = this.getSignedInt(o);
            if (i >= -128 && i <= 127) {
                b.put((byte)99);
                b.put((byte)i);
            } else if (i >= 0 && i <= 255) {
                b.put((byte)67);
                b.put((byte)i);
            } else if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
                b.put((byte)115);
                b.putShort((short)i);
            } else if (i >= 0 && i <= 65535) {
                b.put((byte)83);
                b.putShort((short)i);
            } else {
                b.put((byte)105);
                b.putInt(i);
            }
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
        }

        @Override
        public Object decode(String value) {
            return Integer.parseInt(value);
        }

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof Integer)) {
                try {
                    Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueTypeException("not a valid int : '" + value + "'", e);
                }
            }
        }
    }
    ,
    UNSIGNED_INT('I'){

        @Override
        public boolean isUnsignedInt() {
            return true;
        }

        @Override
        public long getUnsignedInt(Object obj) {
            return Long.parseLong(obj.toString());
        }

        @Override
        public String textEncode(Object o) {
            try {
                return Long.toString(Long.parseLong(o.toString()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("not an u_int", e);
            }
        }

        @Override
        public void encodeInBam(Object o, ByteBuffer b) throws IOException {
            long i = this.getUnsignedInt(o);
            if (i >= -128L && i <= 127L) {
                b.put((byte)99);
                b.put((byte)i);
            } else if (i >= 0L && i <= 255L) {
                b.put((byte)67);
                b.put((byte)i);
            } else if (i >= -32768L && i <= 32767L) {
                b.put((byte)115);
                b.putShort((short)i);
            } else if (i >= 0L && i <= 65535L) {
                b.put((byte)83);
                b.putShort((short)i);
            } else if (i >= Integer.MIN_VALUE && i <= Integer.MAX_VALUE) {
                b.put((byte)105);
                b.putInt((int)i);
            } else {
                b.put((byte)73);
                b.putInt((int)i);
            }
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
        }

        @Override
        public Object decode(String value) {
            return Long.parseLong(value);
        }

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof Long)) {
                try {
                    Long.parseLong(value.toString());
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueTypeException("not a valid int : '" + value + "'", e);
                }
            }
        }
    }
    ,
    FLOAT('f'){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof Float)) {
                throw new InvalidValueTypeException("not a valid float");
            }
        }

        @Override
        public boolean isFloat() {
            return true;
        }

        @Override
        public int getSignedInt(Object obj) {
            return Integer.parseInt(obj.toString());
        }

        @Override
        public String textEncode(Object o) {
            try {
                return Float.toString(Float.parseFloat(o.toString()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("not an float", e);
            }
        }

        @Override
        public float getFloat(Object obj) {
            return Float.parseFloat(obj.toString());
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            out.putFloat(this.getFloat(o));
        }

        @Override
        public Object decode(String value) {
            return Float.valueOf(Float.parseFloat(value));
        }
    }
    ,
    STRING('Z'){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof String)) {
                throw new InvalidValueTypeException("not a valid String");
            }
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public String getString(Object obj) {
            return obj.toString();
        }

        @Override
        public String textEncode(Object o) {
            return o.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            out.put(o.toString().getBytes(IOUtil.UTF_8));
            out.put((byte)0);
        }

        @Override
        public Object decode(String value) {
            if (value == null) {
                throw new NullPointerException("value can not be null");
            }
            return value;
        }
    }
    ,
    BYTE_ARRAY_IN_HEX('H'){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof byte[])) {
                throw new InvalidValueTypeException("not a valid byte array");
            }
        }

        @Override
        public boolean isByteArray() {
            return true;
        }

        @Override
        public byte[] getByteArray(Object obj) {
            return (byte[])obj;
        }

        @Override
        public String textEncode(Object o) {
            byte[] array = (byte[])o;
            StringBuilder builder = new StringBuilder(3 + 2 * array.length);
            for (int i = 0; i < array.length; ++i) {
                builder.append(HEX_ARRAY[IOUtil.toUnsignedByte(array[i])]);
            }
            return builder.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            out.put(this.textEncode(o).getBytes(IOUtil.UTF_8));
            out.put((byte)0);
        }

        @Override
        public Object decode(String value) {
            if (value.charAt(0) != this.optionalArrayType.charValue()) {
                throw new IllegalArgumentException("must be hex string with in H format" + value);
            }
            byte[] array = new byte[(value.length() - 1) / 2];
            for (int i = 1; i < value.length(); i += 2) {
                String hex = value.substring(i, i + 2);
                array[i] = Byte.parseByte(hex, 16);
            }
            return array;
        }
    }
    ,
    SIGNED_BYTE_ARRAY('B', Character.valueOf('c')){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof byte[])) {
                throw new InvalidValueTypeException("not a valid byte array");
            }
        }

        @Override
        public boolean isByteArray() {
            return true;
        }

        @Override
        public byte[] getByteArray(Object obj) {
            return (byte[])obj;
        }

        @Override
        public String textEncode(Object o) {
            byte[] array = (byte[])o;
            StringBuilder builder = new StringBuilder(3 + 4 * array.length);
            for (int i = 0; i < array.length; ++i) {
                builder.append(Byte.toString(array[i])).append(',');
            }
            return builder.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            byte[] array = (byte[])o;
            out.put((byte)(this.optionalArrayType.charValue() & 0xFF));
            out.putInt(array.length);
            out.put(array);
        }

        @Override
        public Object decode(String value) {
            String[] split = this.parseArrayElementsFrom(value);
            byte[] ret = new byte[split.length];
            for (int i = 0; i < split.length; ++i) {
                ret[i] = Byte.parseByte(split[i]);
            }
            return ret;
        }
    }
    ,
    UNSIGNED_BYTE_ARRAY('B', Character.valueOf('C')){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof UnsignedByteArray)) {
                throw new InvalidValueTypeException("not a valid unsigned byte array");
            }
        }

        @Override
        public boolean isUnsignedByteArray() {
            return true;
        }

        @Override
        public UnsignedByteArray getUnsignedByteArray(Object obj) {
            return (UnsignedByteArray)obj;
        }

        @Override
        public String textEncode(Object o) {
            UnsignedByteArray array = (UnsignedByteArray)o;
            int length = array.getLength();
            StringBuilder builder = new StringBuilder(3 + 4 * length);
            for (int i = 0; i < length; ++i) {
                builder.append(Integer.toString(array.get(i))).append(',');
            }
            return builder.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            UnsignedByteArray array = (UnsignedByteArray)o;
            out.put((byte)(this.optionalArrayType.charValue() & 0xFF));
            int length = array.getLength();
            out.putInt(length);
            for (int i = 0; i < length; ++i) {
                out.put((byte)array.get(i));
            }
        }

        @Override
        public Object decode(String value) {
            String[] split = this.parseArrayElementsFrom(value);
            byte[] ret = new byte[split.length];
            for (int i = 0; i < split.length; ++i) {
                ret[i] = IOUtil.toSignedByte(Integer.parseInt(split[i]));
            }
            return new UnsignedByteArray(ret);
        }
    }
    ,
    SIGNED_SHORT_ARRAY('B', Character.valueOf('s')){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof short[])) {
                throw new InvalidValueTypeException("not a valid short array");
            }
        }

        @Override
        public boolean isShortArray() {
            return true;
        }

        @Override
        public short[] getShortArray(Object obj) {
            return (short[])obj;
        }

        @Override
        public String textEncode(Object o) {
            short[] array = (short[])o;
            StringBuilder builder = new StringBuilder(3 + 7 * array.length);
            for (int i = 0; i < array.length; ++i) {
                builder.append(Short.toString(array[i])).append(',');
            }
            return builder.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            short[] array = (short[])o;
            out.put((byte)(this.optionalArrayType.charValue() & 0xFF));
            out.putInt(array.length);
            out.asShortBuffer().put(array);
        }

        @Override
        public Object decode(String value) {
            String[] split = this.parseArrayElementsFrom(value);
            short[] ret = new short[split.length];
            for (int i = 0; i < split.length; ++i) {
                ret[i] = Short.parseShort(split[i]);
            }
            return ret;
        }
    }
    ,
    UNSIGNED_SHORT_ARRAY('B', Character.valueOf('S')){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof UnsignedShortArray)) {
                throw new InvalidValueTypeException("not a valid short array");
            }
        }

        @Override
        public boolean isUnsignedShortArray() {
            return true;
        }

        @Override
        public UnsignedShortArray getUnsignedShortArray(Object obj) {
            return (UnsignedShortArray)obj;
        }

        @Override
        public String textEncode(Object o) {
            UnsignedShortArray array = (UnsignedShortArray)o;
            int length = array.getLength();
            StringBuilder builder = new StringBuilder(3 + 6 * length);
            for (int i = 0; i < length; ++i) {
                builder.append(Integer.toString(array.get(i))).append(',');
            }
            return builder.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            UnsignedShortArray array = (UnsignedShortArray)o;
            out.put((byte)(this.optionalArrayType.charValue() & 0xFF));
            int length = array.getLength();
            out.putInt(length);
            ShortBuffer sb = out.asShortBuffer();
            for (int i = 0; i < length; ++i) {
                sb.put((short)array.get(i));
            }
        }

        @Override
        public Object decode(String value) {
            String[] split = this.parseArrayElementsFrom(value);
            short[] ret = new short[split.length];
            for (int i = 0; i < split.length; ++i) {
                ret[i] = IOUtil.toSignedShort(Integer.parseInt(split[i]));
            }
            return new UnsignedShortArray(ret);
        }
    }
    ,
    SIGNED_INT_ARRAY('B', Character.valueOf('i')){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof int[])) {
                throw new InvalidValueTypeException("not a valid int array");
            }
        }

        @Override
        public boolean isIntArray() {
            return true;
        }

        @Override
        public int[] getIntArray(Object obj) {
            return (int[])obj;
        }

        @Override
        public String textEncode(Object o) {
            int[] array = (int[])o;
            StringBuilder builder = new StringBuilder(3 + 12 * array.length);
            for (int i = 0; i < array.length; ++i) {
                builder.append(Integer.toString(array[i])).append(',');
            }
            return builder.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            int[] array = (int[])o;
            out.put((byte)(this.optionalArrayType.charValue() & 0xFF));
            out.putInt(array.length);
            out.asIntBuffer().put(array);
        }

        @Override
        public Object decode(String value) {
            String[] split = this.parseArrayElementsFrom(value);
            int[] ret = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                ret[i] = Integer.parseInt(split[i]);
            }
            return ret;
        }
    }
    ,
    UNSIGNED_INT_ARRAY('B', Character.valueOf('I')){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof UnsignedIntArray)) {
                throw new InvalidValueTypeException("not a valid unsignedInt array");
            }
        }

        @Override
        public boolean isUnsignedIntArray() {
            return true;
        }

        @Override
        public UnsignedIntArray getUnsignedIntArray(Object obj) {
            return (UnsignedIntArray)obj;
        }

        @Override
        public String textEncode(Object o) {
            UnsignedIntArray array = (UnsignedIntArray)o;
            int length = array.getLength();
            StringBuilder builder = new StringBuilder(3 + 11 * length);
            for (int i = 0; i < length; ++i) {
                builder.append(Long.toString(array.get(i))).append(',');
            }
            return builder.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            UnsignedIntArray array = (UnsignedIntArray)o;
            out.put((byte)(this.optionalArrayType.charValue() & 0xFF));
            int length = array.getLength();
            out.putInt(length);
            IntBuffer ib = out.asIntBuffer();
            for (int i = 0; i < length; ++i) {
                ib.put((int)array.get(i));
            }
        }

        @Override
        public Object decode(String value) {
            String[] split = this.parseArrayElementsFrom(value);
            int[] ret = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                ret[i] = IOUtil.toSignedInt(Long.parseLong(split[i]));
            }
            return new UnsignedIntArray(ret);
        }
    }
    ,
    FLOAT_ARRAY('B', Character.valueOf('f')){

        @Override
        public void validate(Object value) throws InvalidValueTypeException {
            if (!(value instanceof float[])) {
                throw new InvalidValueTypeException("not a valid float array");
            }
        }

        @Override
        public boolean isFloatArray() {
            return true;
        }

        @Override
        public float[] getFloatArray(Object obj) {
            return (float[])obj;
        }

        @Override
        public String textEncode(Object o) {
            float[] array = (float[])o;
            StringBuilder builder = new StringBuilder(3 + 8 * array.length);
            for (int i = 0; i < array.length; ++i) {
                builder.append(Float.toString(array[i])).append(',');
            }
            return builder.toString();
        }

        @Override
        public void binaryEncode(Object o, ByteBuffer out) throws IOException {
            float[] array = (float[])o;
            out.put((byte)(this.optionalArrayType.charValue() & 0xFF));
            out.putInt(array.length);
            out.asFloatBuffer().put(array);
        }

        @Override
        public Object decode(String value) {
            String[] split = this.parseArrayElementsFrom(value);
            float[] ret = new float[split.length];
            for (int i = 0; i < split.length; ++i) {
                ret[i] = Float.parseFloat(split[i]);
            }
            return ret;
        }
    };

    private static final String[] HEX_ARRAY;
    private static final Pattern SPLIT_ARRAY_PATTERN;
    private static final Pattern ARRAY_PATTERN;
    char value;
    Character optionalArrayType;

    private SamAttributeType(char c) {
        this(c, (Character)null);
    }

    private SamAttributeType(char c, Character optionalArrayType) {
        this.value = c;
        this.optionalArrayType = optionalArrayType;
    }

    public String getTextTypeCode() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value).append(':');
        if (this.optionalArrayType != null) {
            builder.append(this.optionalArrayType);
        }
        return builder.toString();
    }

    private void putBinaryTypeCode(ByteBuffer buf) {
        buf.put((byte)(this.value & 0xFF));
        if (this.optionalArrayType != null) {
            buf.put((byte)(this.optionalArrayType.charValue() & 0xFF));
        }
    }

    public abstract String textEncode(Object var1);

    public void encodeInBam(Object o, ByteBuffer b) throws IOException {
        this.putBinaryTypeCode(b);
        this.binaryEncode(o, b);
    }

    abstract void binaryEncode(Object var1, ByteBuffer var2) throws IOException;

    public abstract Object decode(String var1);

    protected String[] parseArrayElementsFrom(String value) {
        Matcher matcher = ARRAY_PATTERN.matcher(value.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid encoded array " + value);
        }
        char code = matcher.group(1).charAt(0);
        if (!this.optionalArrayType.equals(Character.valueOf(code))) {
            throw new IllegalArgumentException(String.format("incorrect array type: expected :%s but was %s: %s", this.optionalArrayType, Character.valueOf(code), value));
        }
        return SPLIT_ARRAY_PATTERN.split(matcher.group(2));
    }

    public boolean isPrintableCharacter() {
        return false;
    }

    public char getPrintableCharacter(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isSignedInt() {
        return false;
    }

    public int getSignedInt(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isUnsignedInt() {
        return false;
    }

    public long getUnsignedInt(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isFloat() {
        return false;
    }

    public float getFloat(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isString() {
        return false;
    }

    public String getString(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isByteArray() {
        return false;
    }

    public byte[] getByteArray(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isShortArray() {
        return false;
    }

    public short[] getShortArray(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isIntArray() {
        return false;
    }

    public int[] getIntArray(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isUnsignedByteArray() {
        return false;
    }

    public UnsignedByteArray getUnsignedByteArray(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isUnsignedShortArray() {
        return false;
    }

    public UnsignedShortArray getUnsignedShortArray(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isUnsignedIntArray() {
        return false;
    }

    public UnsignedIntArray getUnsignedIntArray(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean isFloatArray() {
        return false;
    }

    public float[] getFloatArray(Object obj) {
        throw new UnsupportedOperationException();
    }

    public abstract void validate(Object var1) throws InvalidValueTypeException;

    public static SamAttributeType parseType(char typeCode, String value) {
        if (typeCode == 'B') {
            char arrayType = value.charAt(0);
            switch (arrayType) {
                case 'C': {
                    return UNSIGNED_BYTE_ARRAY;
                }
                case 'D': {
                    return null;
                }
                case 'E': {
                    return null;
                }
                case 'F': {
                    return null;
                }
                case 'G': {
                    return null;
                }
                case 'H': {
                    return null;
                }
                case 'I': {
                    return UNSIGNED_INT_ARRAY;
                }
                case 'J': {
                    return null;
                }
                case 'K': {
                    return null;
                }
                case 'L': {
                    return null;
                }
                case 'M': {
                    return null;
                }
                case 'N': {
                    return null;
                }
                case 'O': {
                    return null;
                }
                case 'P': {
                    return null;
                }
                case 'Q': {
                    return null;
                }
                case 'R': {
                    return null;
                }
                case 'S': {
                    return UNSIGNED_SHORT_ARRAY;
                }
                case 'T': {
                    return null;
                }
                case 'U': {
                    return null;
                }
                case 'V': {
                    return null;
                }
                case 'W': {
                    return null;
                }
                case 'X': {
                    return null;
                }
                case 'Y': {
                    return null;
                }
                case 'Z': {
                    return null;
                }
                case '[': {
                    return null;
                }
                case '\\': {
                    return null;
                }
                case ']': {
                    return null;
                }
                case '^': {
                    return null;
                }
                case '_': {
                    return null;
                }
                case '`': {
                    return null;
                }
                case 'a': {
                    return null;
                }
                case 'b': {
                    return null;
                }
                case 'c': {
                    return SIGNED_BYTE_ARRAY;
                }
                case 'd': {
                    return null;
                }
                case 'e': {
                    return null;
                }
                case 'f': {
                    return FLOAT_ARRAY;
                }
                case 'g': {
                    return null;
                }
                case 'h': {
                    return null;
                }
                case 'i': {
                    return SIGNED_INT_ARRAY;
                }
                case 'j': {
                    return null;
                }
                case 'k': {
                    return null;
                }
                case 'l': {
                    return null;
                }
                case 'm': {
                    return null;
                }
                case 'n': {
                    return null;
                }
                case 'o': {
                    return null;
                }
                case 'p': {
                    return null;
                }
                case 'q': {
                    return null;
                }
                case 'r': {
                    return null;
                }
                case 's': {
                    return SIGNED_SHORT_ARRAY;
                }
            }
            return null;
        }
        if ('Z' == typeCode) {
            return STRING;
        }
        if ('i' == typeCode || 'I' == typeCode || 'c' == typeCode || 'C' == typeCode || 's' == typeCode || 'S' == typeCode) {
            return SIGNED_INT;
        }
        if ('f' == typeCode) {
            return FLOAT;
        }
        if ('A' == typeCode) {
            return PRINTABLE_CHARACTER;
        }
        if ('H' == typeCode) {
            return BYTE_ARRAY_IN_HEX;
        }
        return null;
    }

    static {
        HEX_ARRAY = new String[255];
        SPLIT_ARRAY_PATTERN = Pattern.compile(",");
        ARRAY_PATTERN = Pattern.compile("[cCsSiIf](,[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)+");
        for (int i = 0; i < HEX_ARRAY.length; ++i) {
            SamAttributeType.HEX_ARRAY[i] = String.format("%02X", i);
        }
    }
}

