/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.attribute;

import org.jcvi.jillion.sam.attribute.SamAttributeKey;

public final class SamAttributeKeyFactory {
    private static final SamAttributeKey[][] CACHE = new SamAttributeKey[122][122];

    private SamAttributeKeyFactory() {
    }

    public static SamAttributeKey getKey(String key) {
        if (key.length() != 2) {
            throw new IllegalArgumentException("key string must be 2 chars long " + key);
        }
        return SamAttributeKeyFactory.getKey(key.charAt(0), key.charAt(1));
    }

    public static SamAttributeKey getKey(char first, char second) {
        SamAttributeKeyFactory.assertValidRange(first);
        SamAttributeKeyFactory.assertValidRange(second);
        SamAttributeKey key = CACHE[first][second];
        if (key == null) {
            SamAttributeKeyFactory.CACHE[first][second] = key = new SamAttributeKey(first, second);
        }
        return key;
    }

    private static void assertValidRange(char c) {
        if (c >= CACHE.length) {
            throw new IllegalArgumentException("invalid char codepoint: " + c);
        }
    }
}

