/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.attribute;

import org.jcvi.jillion.core.util.UnsignedByteArray;
import org.jcvi.jillion.core.util.UnsignedIntArray;
import org.jcvi.jillion.core.util.UnsignedShortArray;
import org.jcvi.jillion.sam.attribute.ReservedSamAttributeKeys;
import org.jcvi.jillion.sam.attribute.SamAttributeKey;
import org.jcvi.jillion.sam.attribute.SamAttributeType;

public class SamAttribute {
    private final SamAttributeKey key;
    private final SamAttributeType type;
    private final Object value;

    public SamAttribute(ReservedSamAttributeKeys key, Object value) {
        this(key.getKey(), key.getType(), value);
    }

    public SamAttribute(SamAttributeKey key, SamAttributeType type, Object value) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        if (type == null) {
            throw new NullPointerException("type can not be null");
        }
        if (value == null) {
            throw new NullPointerException("value can not be null");
        }
        type.validate(value);
        this.key = key;
        this.type = type;
        this.value = value;
    }

    public SamAttributeType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public SamAttributeKey getKey() {
        return this.key;
    }

    public boolean isPrintableCharacter() {
        return this.type.isPrintableCharacter();
    }

    public char getPrintableCharacter() {
        return this.type.getPrintableCharacter(this.value);
    }

    public boolean isSignedInt() {
        return this.type.isSignedInt();
    }

    public int getSignedInt() {
        return this.type.getSignedInt(this.value);
    }

    public boolean isFloat() {
        return this.type.isFloat();
    }

    public float getFloat() {
        return this.type.getFloat(this.value);
    }

    public boolean isString() {
        return this.type.isString();
    }

    public String getString() {
        return this.type.getString(this.value);
    }

    public boolean isByteArray() {
        return this.type.isByteArray();
    }

    public byte[] getByteArray() {
        return this.type.getByteArray(this.value);
    }

    public boolean isShortArray() {
        return this.type.isShortArray();
    }

    public short[] getShortArray() {
        return this.type.getShortArray(this.value);
    }

    public boolean isIntArray() {
        return this.type.isIntArray();
    }

    public int[] getIntArray() {
        return this.type.getIntArray(this.value);
    }

    public boolean isUnsignedByteArray() {
        return this.type.isUnsignedByteArray();
    }

    public UnsignedByteArray getUnsignedByteArray() {
        return this.type.getUnsignedByteArray(this.value);
    }

    public boolean isUnsignedShortArray() {
        return this.type.isUnsignedShortArray();
    }

    public UnsignedShortArray getUnsignedShortArray() {
        return this.type.getUnsignedShortArray(this.value);
    }

    public boolean isUnsignedIntArray() {
        return this.type.isUnsignedIntArray();
    }

    public UnsignedIntArray getUnsignedIntArray() {
        return this.type.getUnsignedIntArray(this.value);
    }

    public boolean isFloatArray() {
        return this.type.isFloatArray();
    }

    public float[] getFloatArray() {
        return this.type.getFloatArray(this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.type.textEncode(this.value).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamAttribute)) {
            return false;
        }
        SamAttribute other = (SamAttribute)obj;
        if (!this.key.equals(other.key)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.type.textEncode(this.value).equals(this.type.textEncode(other.value));
    }

    public String toString() {
        return "SamAttribute [key=" + this.key + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + "]";
    }
}

