/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.attribute;

import org.jcvi.jillion.sam.attribute.InvalidAttributeException;
import org.jcvi.jillion.sam.attribute.SamAttributeKey;
import org.jcvi.jillion.sam.attribute.SamAttributeKeyFactory;
import org.jcvi.jillion.sam.attribute.SamAttributeType;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReadGroup;

public enum ReservedSamAttributeKeys {
    SMALLEST_MAPPING_QUAL('A', 'M', SamAttributeType.SIGNED_INT),
    ALIGNMENT_SCORE('A', 'S', SamAttributeType.SIGNED_INT),
    BARCODE_SEQUENCE('B', 'C', SamAttributeType.STRING),
    BASE_ALIGNMENT_QUAL_OFFSET('B', 'Q', SamAttributeType.STRING),
    NEXT_HIT_REF_NAME('C', 'C', SamAttributeType.STRING),
    COLOR_EDIT_DISTANCE('C', 'M', SamAttributeType.SIGNED_INT),
    COMMENTS('C', 'O', SamAttributeType.STRING),
    LEFT_COORD_NEXT_HIT('C', 'P', SamAttributeType.SIGNED_INT),
    COLOR_READ_QUAL('C', 'Q', SamAttributeType.STRING),
    COLOR_SEQUENCE('C', 'S', SamAttributeType.STRING),
    COMPLETE_READ_ANNOTATION('C', 'T', SamAttributeType.STRING),
    SECOND_MOSTLY_LIKELY_BASECALLS('E', '2', SamAttributeType.STRING),
    TEMPLATE_INDEX('F', 'I', SamAttributeType.SIGNED_INT),
    SEGMENT_SUFFIX('F', 'S', SamAttributeType.STRING),
    FLOW_SIG('F', 'Z', SamAttributeType.UNSIGNED_SHORT_ARRAY),
    LIBRARY('L', 'B', SamAttributeType.STRING){

        @Override
        public void validate(SamHeader header, Object value) throws InvalidAttributeException {
            String libId = this.getType().getString(value);
            boolean found = false;
            for (SamReadGroup readGroup : header.getReadGroups()) {
                if (!libId.equals(readGroup.getLibrary())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new InvalidAttributeException("header must have read group with id " + value);
            }
        }
    }
    ,
    NUM_PERFECT_HITS('H', '0', SamAttributeType.SIGNED_INT),
    ONE_DIFF_HITS('H', '1', SamAttributeType.SIGNED_INT),
    TWO_DIFF_HITS('H', '2', SamAttributeType.SIGNED_INT),
    QUERY_HIT_INDEX('H', 'I', SamAttributeType.SIGNED_INT),
    NUM_ALIGNMENTS('I', 'H', SamAttributeType.SIGNED_INT),
    MISMATCHING_POSITIONS('M', 'D', SamAttributeType.STRING),
    MATE_OR_NEXT_MAPPING_QUALITY('M', 'Q', SamAttributeType.SIGNED_INT),
    NUM_REPORTED_ALIGNEMENTS('N', 'H', SamAttributeType.SIGNED_INT),
    EDIT_DISTANCE('N', 'M', SamAttributeType.SIGNED_INT),
    ORIGINAL_QUALTY('O', 'Q', SamAttributeType.STRING),
    ORIGINAL_MAPPING_POSITION('O', 'P', SamAttributeType.SIGNED_INT),
    ORIGINAL_CIGAR('O', 'C', SamAttributeType.STRING),
    PROGRAM('P', 'G', SamAttributeType.STRING){

        @Override
        void validate(SamHeader header, Object value) throws InvalidAttributeException {
            if (header.getSamProgram(this.getType().getString(value)) == null) {
                throw new InvalidAttributeException("header does not contain program " + value);
            }
        }
    }
    ,
    PHRED_LIKELIHOOD_OF_TEMPLATE('P', 'Q', SamAttributeType.SIGNED_INT),
    PADDED_ANNOTATIONS('P', 'T', SamAttributeType.STRING),
    PLATFORMT_UNIT('P', 'U', SamAttributeType.STRING){

        @Override
        void validate(SamHeader header, Object value) throws InvalidAttributeException {
            String actualPlatformUnit = this.getType().getString(value);
            boolean found = false;
            for (SamReadGroup group : header.getReadGroups()) {
                String platformUnit = group.getPlatformUnit();
                if (!actualPlatformUnit.equals(platformUnit)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new InvalidAttributeException("header does not contain platform unit " + value);
            }
        }
    }
    ,
    BARCODE_QUALITY('Q', 'T', SamAttributeType.STRING),
    QUALITY_OF_NEXT_OR_MATE('Q', '2', SamAttributeType.STRING),
    SEQUENCE_OF_NEXT_OR_MATE('R', '2', SamAttributeType.STRING),
    READ_GROUP('R', 'G', SamAttributeType.STRING){

        @Override
        void validate(SamHeader header, Object value) throws InvalidAttributeException {
            if (header.getReadGroup(this.getType().getString(value)) == null) {
                throw new InvalidAttributeException("header does not contain program " + value);
            }
        }
    }
    ,
    READ_TAG('R', 'T', SamAttributeType.STRING),
    OTHER_ALIGNMENT('S', 'A', SamAttributeType.STRING),
    MAPPING_QUALITY('S', 'M', SamAttributeType.SIGNED_INT),
    NUM_SEGS_IN_TEMPLATE('T', 'C', SamAttributeType.SIGNED_INT),
    QUAL_SECOND_CALL_WRONG_TOO('Q', '2', SamAttributeType.STRING),
    QUAL_OF_THE_SEGMENT('U', 'Q', SamAttributeType.SIGNED_INT);

    private static final ReservedSamAttributeKeys[][] CACHE;
    private SamAttributeKey key;
    private SamAttributeType type;

    private static int getCacheIndex(char c) {
        return c - 48;
    }

    private ReservedSamAttributeKeys(char c1, char c2, SamAttributeType type) {
        this.key = SamAttributeKeyFactory.getKey(c1, c2);
        this.type = type;
    }

    public SamAttributeKey getKey() {
        return this.key;
    }

    void validate(SamHeader header, Object value) throws InvalidAttributeException {
    }

    public SamAttributeType getType() {
        return this.type;
    }

    public static ReservedSamAttributeKeys parseKey(SamAttributeKey key) {
        return ReservedSamAttributeKeys.parseKey(key.getFirstChar(), key.getSecondChar());
    }

    public static ReservedSamAttributeKeys parseKey(char c1, char c2) {
        return CACHE[ReservedSamAttributeKeys.getCacheIndex(c1)][ReservedSamAttributeKeys.getCacheIndex(c2)];
    }

    public static ReservedSamAttributeKeys parseKey(String key) {
        if (key.length() != 2) {
            throw new IllegalArgumentException("key string must be 2 chars long " + key);
        }
        return ReservedSamAttributeKeys.parseKey(key.charAt(0), key.charAt(1));
    }

    static {
        CACHE = new ReservedSamAttributeKeys[43][43];
        for (ReservedSamAttributeKeys reserved : ReservedSamAttributeKeys.values()) {
            SamAttributeKey key = reserved.getKey();
            ReservedSamAttributeKeys.CACHE[ReservedSamAttributeKeys.getCacheIndex((char)key.getFirstChar())][ReservedSamAttributeKeys.getCacheIndex((char)key.getSecondChar())] = reserved;
        }
    }
}

