/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam.attribute;

import java.util.ArrayList;
import java.util.List;
import org.jcvi.jillion.sam.SamAttributed;
import org.jcvi.jillion.sam.attribute.InvalidAttributeException;
import org.jcvi.jillion.sam.attribute.ReservedAttributeValidator;
import org.jcvi.jillion.sam.attribute.SamAttribute;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.header.SamHeader;

public class ChainedSamAttributeValidatorBuilder {
    private final List<SamAttributeValidator> validators = new ArrayList<SamAttributeValidator>();

    public ChainedSamAttributeValidatorBuilder() {
        this(true);
    }

    public ChainedSamAttributeValidatorBuilder(boolean validateReservedAttributes) {
        if (validateReservedAttributes) {
            this.validators.add(ReservedAttributeValidator.INSTANCE);
        }
    }

    public ChainedSamAttributeValidatorBuilder addValidator(SamAttributeValidator validator) {
        if (validator == null) {
            throw new NullPointerException("validator can not be null");
        }
        this.validators.add(validator);
        return this;
    }

    public SamAttributeValidator build() {
        return new ChainedSamAttributeValidator(this.validators);
    }

    static final class ChainedSamAttributeValidator
    implements SamAttributeValidator {
        private final List<SamAttributeValidator> validators;

        public ChainedSamAttributeValidator(List<SamAttributeValidator> validators) {
            this.validators = new ArrayList<SamAttributeValidator>(validators);
        }

        @Override
        public void validate(SamHeader header, SamAttributed record, SamAttribute attribute) throws InvalidAttributeException {
            for (SamAttributeValidator validator : this.validators) {
                validator.validate(header, record, attribute);
            }
        }
    }
}

