/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

public class VirtualFileOffset
implements Comparable<VirtualFileOffset> {
    private static final long MAX_COMPRESSED_BLOCK_OFFSET = 0x1FFFFFFFFFFFFL;
    private static final int MAX_UNCOMPRESSED_OFFSET = 131071;
    private final long encodedValue;

    public static VirtualFileOffset create(long compressedBlockOffset, int uncompressedOffset) {
        if (compressedBlockOffset < 0L) {
            throw new IllegalArgumentException("compressed BlockOffset can not be negative : " + compressedBlockOffset);
        }
        if (compressedBlockOffset > 0x1FFFFFFFFFFFFL) {
            throw new IllegalArgumentException("compressed BlockOffset can not be larger than 562949953421311 : " + compressedBlockOffset);
        }
        if (uncompressedOffset < 0) {
            throw new IllegalArgumentException("uncompressed offset can not be negative : " + uncompressedOffset);
        }
        if (uncompressedOffset > 131071) {
            throw new IllegalArgumentException("uncompressed offset can not be larger than131071 : " + uncompressedOffset);
        }
        long encodedValue = compressedBlockOffset << 16;
        return new VirtualFileOffset(encodedValue |= (long)uncompressedOffset);
    }

    public VirtualFileOffset nextOffset() {
        long compressedOffset = this.getCompressedBamBlockOffset();
        int uncompressedOffset = this.getUncompressedOffset() + 1;
        if (uncompressedOffset > 131071) {
            uncompressedOffset = 0;
            ++compressedOffset;
        }
        return VirtualFileOffset.create(compressedOffset, uncompressedOffset);
    }

    public VirtualFileOffset(long encodedValue) {
        this.encodedValue = encodedValue;
    }

    public long getEncodedValue() {
        return this.encodedValue;
    }

    public long getCompressedBamBlockOffset() {
        return this.encodedValue >> 16;
    }

    public int getUncompressedOffset() {
        return (int)(this.encodedValue & 0xFFFFL);
    }

    @Override
    public int compareTo(VirtualFileOffset o) {
        if (this.encodedValue < o.encodedValue) {
            return -1;
        }
        if (this.encodedValue == o.encodedValue) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.encodedValue ^ this.encodedValue >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualFileOffset)) {
            return false;
        }
        VirtualFileOffset other = (VirtualFileOffset)obj;
        return this.encodedValue == other.encodedValue;
    }

    public String toString() {
        return "VirtualFileOffset [getCompressedBamBlockOffset()=" + this.getCompressedBamBlockOffset() + ", getUncompressedOffset()=" + this.getUncompressedOffset() + "]";
    }
}

