/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReferenceSequence;

public enum SortOrder {
    UNKNOWN,
    UNSORTED,
    QUERY_NAME{

        @Override
        public Comparator<SamRecord> createComparator(SamHeader header) {
            return QUERY_NAME_COMPARATOR;
        }
    }
    ,
    COORDINATE{

        @Override
        public Comparator<SamRecord> createComparator(SamHeader header) {
            return new CoordinateComparator(header);
        }
    };

    private static final Map<String, SortOrder> NAME_MAP;
    private static final Comparator<SamRecord> QUERY_NAME_COMPARATOR;
    private final String encodedName = this.name().replaceAll("_", "").toLowerCase(Locale.US);

    public String getEncodedName() {
        return this.encodedName;
    }

    public static SortOrder parseSortOrder(String sortOrder) {
        return NAME_MAP.get(sortOrder);
    }

    public Comparator<SamRecord> createComparator(SamHeader header) {
        return null;
    }

    static {
        QUERY_NAME_COMPARATOR = new Comparator<SamRecord>(){

            @Override
            public int compare(SamRecord o1, SamRecord o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getQueryName().compareTo(o2.getQueryName());
            }
        };
        NAME_MAP = new HashMap<String, SortOrder>();
        for (SortOrder s : SortOrder.values()) {
            NAME_MAP.put(s.getEncodedName(), s);
        }
    }

    private static final class CoordinateComparator
    implements Comparator<SamRecord>,
    Serializable {
        private static final long serialVersionUID = -4315866144598924346L;
        private final List<String> referenceNames;

        public CoordinateComparator(SamHeader header) {
            Collection<SamReferenceSequence> refs = header.getReferenceSequences();
            this.referenceNames = new ArrayList<String>(refs.size());
            for (SamReferenceSequence ref : refs) {
                this.referenceNames.add(ref.getName());
            }
        }

        @Override
        public int compare(SamRecord o1, SamRecord o2) {
            String ref2;
            boolean ref2DidNotMap;
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            boolean ref1DidNotMap = !o1.mapped();
            boolean bl = ref2DidNotMap = !o2.mapped();
            if (ref1DidNotMap && ref2DidNotMap) {
                return o1.getQueryName().compareTo(o2.getQueryName());
            }
            if (ref1DidNotMap) {
                return 1;
            }
            if (ref2DidNotMap) {
                return -1;
            }
            String ref1 = o1.getReferenceName();
            if (!ref1.equals(ref2 = o2.getReferenceName())) {
                int index2;
                int index1 = this.referenceNames.indexOf(ref1);
                if (index1 < (index2 = this.referenceNames.indexOf(ref2))) {
                    return -1;
                }
                return 1;
            }
            int startComp = CoordinateComparator.compare(o1.getStartPosition(), o2.getStartPosition());
            if (startComp != 0) {
                return startComp;
            }
            return o1.getQueryName().compareTo(o2.getQueryName());
        }

        private static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

