/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.util.ThrowingStream;
import org.jcvi.jillion.sam.SamFileDataStore;
import org.jcvi.jillion.sam.SamFileWriterBuilder;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SortOrder;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.index.BamIndexFileWriterBuilder;

public interface SamWriter
extends Closeable {
    public void writeRecord(SamRecord var1) throws IOException;

    public static SamWriter newSortedBamWriter(File outputBam, SamHeader header) throws IOException {
        String ext = FileUtil.getExtension(outputBam);
        if (!"bam".equals(ext)) {
            throw new IllegalArgumentException("output file must have a '.bam' extension : " + outputBam);
        }
        return new SamFileWriterBuilder(outputBam, header).reSortBy(SortOrder.COORDINATE).createBamIndex(true, true).build();
    }

    public static File writeBamIndexFor(File sortedBamFile) throws IOException {
        return new BamIndexFileWriterBuilder(sortedBamFile).includeMetaData(true).assumeSorted(true).build();
    }

    public static void writeSorted(File inputSamOrBam, File outputBam) throws IOException {
        try (SamFileDataStore datastore = SamFileDataStore.fromFile(inputSamOrBam);){
            SamWriter.writeSorted(datastore, outputBam);
        }
    }

    public static void writeSorted(File inputSamOrBam, File outputBam, Predicate<SamRecord> filter) throws IOException {
        try (SamFileDataStore datastore = SamFileDataStore.fromFile(inputSamOrBam);){
            SamWriter.writeSorted(datastore, outputBam, filter);
        }
    }

    public static void writeSorted(SamFileDataStore datastore, File outputBam) throws IOException {
        try (SamWriter writer = SamWriter.newSortedBamWriter(outputBam, datastore.getHeader());
             ThrowingStream<SamRecord> stream = datastore.records();){
            stream.throwingForEach(record -> writer.writeRecord((SamRecord)record));
        }
    }

    public static void writeSorted(SamFileDataStore datastore, File outputBam, Predicate<SamRecord> filter) throws IOException {
        if (filter == null) {
            SamWriter.writeSorted(datastore, outputBam);
            return;
        }
        try (SamWriter writer = SamWriter.newSortedBamWriter(outputBam, datastore.getHeader());
             ThrowingStream stream = datastore.records();){
            stream.filter(filter).throwingForEach(record -> writer.writeRecord((SamRecord)record));
        }
    }
}

