/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamRecordBuilder;
import org.jcvi.jillion.sam.SamRecordFlag;
import org.jcvi.jillion.sam.SamRecordFlags;
import org.jcvi.jillion.sam.attribute.ReservedSamAttributeKeys;
import org.jcvi.jillion.sam.attribute.SamAttribute;
import org.jcvi.jillion.sam.attribute.SamAttributeKey;
import org.jcvi.jillion.sam.cigar.Cigar;
import org.jcvi.jillion.sam.header.SamHeader;

class SamRecordImpl
implements SamRecord {
    private final SamHeader header;
    private final String queryName;
    private final String referenceName;
    private final String nextReferenceName;
    private final SamRecordFlags flags;
    private final int startPosition;
    private final int nextOffset;
    private final byte mappingQuality;
    private final Cigar cigar;
    private final NucleotideSequence sequence;
    private final QualitySequence qualities;
    private final int observedTemplateLength;
    private final Map<SamAttributeKey, SamAttribute> attributes;

    SamRecordImpl(SamRecordBuilder builder) {
        this.header = builder.header;
        this.queryName = builder.queryName;
        this.flags = builder.flags;
        this.referenceName = builder.referenceName;
        this.startPosition = builder.startPosition;
        this.mappingQuality = builder.mappingQuality;
        this.cigar = builder.cigar;
        this.nextOffset = builder.nextPosition;
        this.observedTemplateLength = builder.observedTemplateLength;
        this.sequence = builder.sequence;
        this.qualities = builder.qualities;
        this.attributes = Collections.unmodifiableMap(builder.attributes);
        this.nextReferenceName = "=".equals(builder.nextReferenceName) ? this.referenceName : builder.nextReferenceName;
    }

    @Override
    public boolean isPrimary() {
        return !this.flags.contains(SamRecordFlag.SECONDARY_ALIGNMENT) && !this.flags.contains(SamRecordFlag.SUPPLEMENTARY_ALIGNMENT);
    }

    @Override
    public boolean useForAnalysis() {
        return !this.flags.contains(SamRecordFlag.SECONDARY_ALIGNMENT);
    }

    protected SamHeader getHeader() {
        return this.header;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public String getNextName() {
        return this.nextReferenceName;
    }

    @Override
    public SamRecordFlags getFlags() {
        return this.flags;
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public byte getMappingQuality() {
        return this.mappingQuality;
    }

    @Override
    public Cigar getCigar() {
        return this.cigar;
    }

    @Override
    public NucleotideSequence getSequence() {
        return this.sequence;
    }

    @Override
    public QualitySequence getQualities() {
        return this.qualities;
    }

    @Override
    public int getObservedTemplateLength() {
        return this.observedTemplateLength;
    }

    @Override
    public boolean hasAttribute(SamAttributeKey key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        return this.attributes.containsKey(key);
    }

    @Override
    public SamAttribute getAttribute(SamAttributeKey key) {
        Objects.requireNonNull(key);
        return this.attributes.get(key);
    }

    @Override
    public Collection<SamAttribute> getAttributes() {
        return this.attributes.values();
    }

    @Override
    public boolean hasAttribute(ReservedSamAttributeKeys key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        return this.hasAttribute(key.getKey());
    }

    @Override
    public SamAttribute getAttribute(ReservedSamAttributeKeys key) {
        Objects.requireNonNull(key);
        return this.getAttribute(key.getKey());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.cigar == null ? 0 : this.cigar.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + this.mappingQuality;
        result = 31 * result + this.nextOffset;
        result = 31 * result + (this.nextReferenceName == null ? 0 : this.nextReferenceName.hashCode());
        result = 31 * result + this.observedTemplateLength;
        result = 31 * result + (this.qualities == null ? 0 : this.qualities.hashCode());
        result = 31 * result + (this.queryName == null ? 0 : this.queryName.hashCode());
        result = 31 * result + this.referenceName.hashCode();
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        result = 31 * result + this.startPosition;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamRecordImpl)) {
            return false;
        }
        SamRecordImpl other = (SamRecordImpl)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.cigar == null ? other.cigar != null : !this.cigar.equals(other.cigar)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.mappingQuality != other.mappingQuality) {
            return false;
        }
        if (this.nextOffset != other.nextOffset) {
            return false;
        }
        if (this.nextReferenceName == null ? other.nextReferenceName != null : !this.nextReferenceName.equals(other.nextReferenceName)) {
            return false;
        }
        if (this.observedTemplateLength != other.observedTemplateLength) {
            return false;
        }
        if (this.qualities == null ? other.qualities != null : !this.qualities.equals(other.qualities)) {
            return false;
        }
        if (this.queryName == null ? other.queryName != null : !this.queryName.equals(other.queryName)) {
            return false;
        }
        if (this.referenceName == null ? other.referenceName != null : !this.referenceName.equals(other.referenceName)) {
            return false;
        }
        if (this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence)) {
            return false;
        }
        return this.startPosition == other.startPosition;
    }

    @Override
    public String toString() {
        return "SamRecord [queryName=" + this.queryName + ", referenceName=" + this.referenceName + ", nextReferenceName=" + this.nextReferenceName + ", flags=" + this.flags + ", startPosition=" + this.startPosition + ", nextOffset=" + this.nextOffset + ", mappingQuality=" + this.mappingQuality + ", cigar=" + this.cigar + ", sequence=" + this.sequence + ", qualities=" + this.qualities + ", observedTemplateLength=" + this.observedTemplateLength + ", attributes=" + this.attributes + "]";
    }

    @Override
    public boolean mapped() {
        return !this.flags.contains(SamRecordFlag.READ_UNMAPPED);
    }

    @Override
    public Direction getDirection() {
        return this.flags.contains(SamRecordFlag.REVERSE_COMPLEMENTED) ? Direction.REVERSE : Direction.FORWARD;
    }

    @Override
    public Range getAlignmentRange() {
        if (this.mapped()) {
            return new Range.Builder(this.cigar.getNumberOfReferenceBasesAligned()).shift(this.startPosition - 1).build();
        }
        return null;
    }
}

