/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.sam.SamRecordFlag;

public class SamRecordFlags {
    private static final ConcurrentHashMap<Integer, SamRecordFlags> CACHE = new ConcurrentHashMap();
    private int setBits;

    public static SamRecordFlags valueOf(int bits) {
        return CACHE.computeIfAbsent(bits, i -> new SamRecordFlags((int)i));
    }

    public static SamRecordFlags valueOf(BitSet bits) {
        return SamRecordFlags.valueOf((int)bits.toLongArray()[0]);
    }

    public static SamRecordFlags valueOf(Collection<SamRecordFlag> flags) {
        int v = 0;
        for (SamRecordFlag f : flags) {
            v |= f.getBitFlags();
        }
        return SamRecordFlags.valueOf(v);
    }

    public static SamRecordFlags valueOf(SamRecordFlag ... flags) {
        int v = 0;
        for (SamRecordFlag f : flags) {
            v |= f.getBitFlags();
        }
        return SamRecordFlags.valueOf(v);
    }

    private SamRecordFlags(int setBits) {
        this.setBits = setBits;
    }

    public int asInt() {
        return this.setBits;
    }

    public BitSet asBitSet() {
        return IOUtil.toBitSet(this.setBits);
    }

    public boolean contains(SamRecordFlag flag) {
        return flag.matches(this.setBits);
    }

    public SamRecordFlags add(SamRecordFlag flag) {
        int newValue = this.setBits;
        return SamRecordFlags.valueOf(newValue |= flag.getBitFlags());
    }

    public SamRecordFlags add(SamRecordFlag flag, SamRecordFlag ... additionalFlags) {
        int newValue = this.setBits;
        newValue |= flag.getBitFlags();
        for (SamRecordFlag f : additionalFlags) {
            newValue |= f.getBitFlags();
        }
        return SamRecordFlags.valueOf(newValue);
    }

    public SamRecordFlags remove(SamRecordFlag flag) {
        int newValue = this.setBits;
        return SamRecordFlags.valueOf(newValue ^= flag.getBitFlags());
    }

    public SamRecordFlags remove(SamRecordFlag flag, SamRecordFlag ... additionalFlags) {
        int newValue = this.setBits;
        newValue ^= flag.getBitFlags();
        for (SamRecordFlag f : additionalFlags) {
            newValue ^= f.getBitFlags();
        }
        return SamRecordFlags.valueOf(newValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.setBits;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamRecordFlags)) {
            return false;
        }
        SamRecordFlags other = (SamRecordFlags)obj;
        return this.setBits == other.setBits;
    }

    public Set<SamRecordFlag> getFlags() {
        return SamRecordFlag.parseFlags(this.setBits);
    }

    public String toString() {
        return "SamRecordFlags [setBits=" + this.setBits + " flags = " + this.getFlags() + " ]";
    }

    public boolean maybeReferenceSequence() {
        return this.setBits == 516;
    }

    public boolean isAnnotation() {
        return this.setBits == 768;
    }
}

