/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.util.EnumSet;
import java.util.Set;

public enum SamRecordFlag {
    HAS_MATE_PAIR(1),
    EACH_SEGMENT_PROPERLY_ALIGNED(2),
    READ_UNMAPPED(4),
    MATE_UNMAPPED(8),
    REVERSE_COMPLEMENTED(16),
    MATE_REVERSE_COMPLEMENTED(32),
    FIRST_MATE_OF_PAIR(64),
    SECOND_MATE_OF_PAIR(128),
    SECONDARY_ALIGNMENT(256),
    FAILED_QC(512),
    DUPLICATE(1024),
    SUPPLEMENTARY_ALIGNMENT(2048);

    private final short value;

    private SamRecordFlag(int value) {
        this.value = (short)value;
    }

    public int getBitFlags() {
        return this.value;
    }

    public boolean matches(int bitflags) {
        return this.value == (bitflags & this.value);
    }

    public static Set<SamRecordFlag> parseFlags(int bitFlags) {
        if (bitFlags < 0) {
            throw new IllegalArgumentException("bit flags value can not be negative");
        }
        EnumSet<SamRecordFlag> set = EnumSet.noneOf(SamRecordFlag.class);
        for (SamRecordFlag flag : SamRecordFlag.values()) {
            if (!flag.matches(bitFlags)) continue;
            set.add(flag);
        }
        return set;
    }

    public static int asBits(Set<SamRecordFlag> flags) {
        int value = 0;
        for (SamRecordFlag flag : flags) {
            value |= flag.value;
        }
        return value;
    }
}

