/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.sam.SamAttributed;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamRecordFlag;
import org.jcvi.jillion.sam.SamRecordFlags;
import org.jcvi.jillion.sam.SamRecordImpl;
import org.jcvi.jillion.sam.attribute.InvalidAttributeException;
import org.jcvi.jillion.sam.attribute.ReservedAttributeValidator;
import org.jcvi.jillion.sam.attribute.ReservedSamAttributeKeys;
import org.jcvi.jillion.sam.attribute.SamAttribute;
import org.jcvi.jillion.sam.attribute.SamAttributeKey;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.cigar.Cigar;
import org.jcvi.jillion.sam.header.SamHeader;

public class SamRecordBuilder
implements SamAttributed {
    final SamHeader header;
    private final SamAttributeValidator attributeValidator;
    final Map<SamAttributeKey, SamAttribute> attributes = new LinkedHashMap<SamAttributeKey, SamAttribute>();
    String queryName = "*";
    String referenceName = null;
    String nextReferenceName = null;
    SamRecordFlags flags;
    int startPosition = 0;
    int nextPosition = 0;
    byte mappingQuality = (byte)-1;
    Cigar cigar;
    NucleotideSequence sequence;
    QualitySequence qualities;
    int observedTemplateLength = 0;

    public SamRecordBuilder(SamHeader header) {
        this(header, ReservedAttributeValidator.INSTANCE);
    }

    public SamRecordBuilder(SamHeader header, SamAttributeValidator attributeValidator) {
        if (header == null) {
            throw new NullPointerException("header can not be null");
        }
        if (attributeValidator == null) {
            throw new NullPointerException("attribute Validator can not be null");
        }
        this.header = header;
        this.attributeValidator = attributeValidator;
    }

    public SamRecordBuilder addAttribute(SamAttribute attribute) throws InvalidAttributeException {
        if (attribute == null) {
            throw new NullPointerException("attribute can not be null");
        }
        SamAttributeKey key = attribute.getKey();
        this.attributeValidator.validate(this.header, this, attribute);
        this.attributes.put(key, attribute);
        return this;
    }

    public SamRecordBuilder removeAttribute(SamAttributeKey attributeKey) {
        if (attributeKey == null) {
            throw new NullPointerException("attribute key can not be null");
        }
        this.attributes.remove(attributeKey);
        return this;
    }

    public SamRecordBuilder setQueryName(String queryName) {
        if (queryName == null) {
            throw new NullPointerException("query name can not be null");
        }
        this.queryName = queryName;
        return this;
    }

    public SamRecordBuilder setReferenceName(String referenceName) {
        if (referenceName == null) {
            throw new NullPointerException("reference name can not be null");
        }
        if ("*".equals(referenceName)) {
            this.referenceName = null;
        } else {
            this.assertHeaderKnowsAboutReference(referenceName);
            this.referenceName = referenceName;
        }
        return this;
    }

    private void assertHeaderKnowsAboutReference(String referenceName) {
        if (this.header.getReferenceSequence(referenceName) == null) {
            throw new IllegalArgumentException("reference name is not in sam header '" + referenceName + "'");
        }
    }

    public SamRecordBuilder setNextReferenceName(String nextReferenceName) {
        if (nextReferenceName == null) {
            throw new NullPointerException("next reference name can not be null");
        }
        if (nextReferenceName.equals("*")) {
            this.nextReferenceName = null;
        } else {
            if (!nextReferenceName.equals("*") && !nextReferenceName.equals("=")) {
                this.assertHeaderKnowsAboutReference(nextReferenceName);
            }
            this.nextReferenceName = nextReferenceName;
        }
        return this;
    }

    public SamRecordBuilder setFlags(int flags) {
        this.flags = SamRecordFlags.valueOf(flags);
        return this;
    }

    public SamRecordBuilder setFlags(Set<SamRecordFlag> flags) {
        this.flags = SamRecordFlags.valueOf(flags);
        return this;
    }

    public SamRecordBuilder setStartPosition(int startPosition) {
        this.assertValidPosition(startPosition);
        this.startPosition = startPosition;
        return this;
    }

    private void assertValidPosition(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException("position must be >=0 ");
        }
    }

    public SamRecordBuilder setNextPosition(int nextPosition) {
        this.assertValidPosition(nextPosition);
        this.nextPosition = nextPosition;
        return this;
    }

    public SamRecordBuilder setMappingQuality(int mappingQuality) {
        if (mappingQuality > 127) {
            throw new IllegalArgumentException("invalid mapping quality " + mappingQuality);
        }
        return this.setMappingQuality((byte)mappingQuality);
    }

    public SamRecordBuilder setMappingQuality(byte mappingQuality) {
        if (mappingQuality < -1) {
            throw new IllegalArgumentException("invalid mapping quality " + mappingQuality);
        }
        this.mappingQuality = mappingQuality;
        return this;
    }

    public SamRecordBuilder setCigar(Cigar cigar) {
        this.cigar = cigar;
        return this;
    }

    public SamRecordBuilder setSequence(NucleotideSequence sequence) {
        this.sequence = sequence;
        return this;
    }

    public SamRecordBuilder setQualities(QualitySequence qualities) {
        this.qualities = qualities;
        return this;
    }

    public SamRecordBuilder setObservedTemplateLength(int observedTemplateLength) {
        this.observedTemplateLength = observedTemplateLength;
        return this;
    }

    public SamRecord build() {
        this.assertSequenceLengthsCorrect();
        if (this.flags == null) {
            throw new IllegalStateException("flags must be set");
        }
        if ("=".equals(this.nextReferenceName)) {
            this.nextReferenceName = this.referenceName;
        }
        return new SamRecordImpl(this);
    }

    private void assertSequenceLengthsCorrect() {
        if (this.qualities != null) {
            if (this.sequence == null) {
                throw new IllegalStateException("sequence must be set if qualities are set");
            }
            if (this.sequence.getLength() != this.qualities.getLength()) {
                throw new IllegalStateException("sequence and qualities must have same length");
            }
        }
        if (this.sequence != null && this.cigar != null && this.sequence.getUngappedLength() != (long)this.cigar.getUnpaddedReadLength(Cigar.ClipType.HARD_CLIPPED)) {
            throw new IllegalStateException("sequence and cigar must have same unpadded/ ungapped read length");
        }
    }

    @Override
    public boolean hasAttribute(SamAttributeKey key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        return this.attributes.containsKey(key);
    }

    @Override
    public SamAttribute getAttribute(SamAttributeKey key) {
        return this.attributes.get(key);
    }

    @Override
    public boolean hasAttribute(ReservedSamAttributeKeys key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        return this.hasAttribute(key.getKey());
    }

    @Override
    public SamAttribute getAttribute(ReservedSamAttributeKeys key) {
        if (key == null) {
            return null;
        }
        return this.getAttribute(key.getKey());
    }
}

