/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.sam.BamFileParser;
import org.jcvi.jillion.sam.IndexedBamFileParser;
import org.jcvi.jillion.sam.SamFileParser;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SortOrder;
import org.jcvi.jillion.sam.attribute.ReservedAttributeValidator;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;

public final class SamParserFactory {
    private SamParserFactory() {
    }

    public static SamParser create(File f) throws IOException {
        return SamParserFactory.create(f, ReservedAttributeValidator.INSTANCE);
    }

    public static SamParser create(File f, SamAttributeValidator validator) throws IOException {
        if (validator == null) {
            throw new NullPointerException("validator can not be null");
        }
        IOUtil.verifyIsReadable(f);
        String extension = FileUtil.getExtension(f);
        if ("sam".equalsIgnoreCase(extension)) {
            return new SamFileParser(f, validator);
        }
        if ("bam".equalsIgnoreCase(extension)) {
            return SamParserFactory.createFromBamFile(f, validator);
        }
        throw new IllegalArgumentException("unknown file format " + f.getName());
    }

    private static SamParser createFromBamFile(File f, SamAttributeValidator validator) throws IOException {
        File bai;
        BamFileParser unsortedBamParser = new BamFileParser(f, validator);
        if (unsortedBamParser.getHeader().getSortOrder() == SortOrder.COORDINATE && (bai = new File(f.getParentFile(), f.getName() + ".bai")).exists()) {
            return SamParserFactory.createUsingIndex(f, bai, validator);
        }
        return unsortedBamParser;
    }

    public static SamParser createUsingIndex(File bam, File bamIndex) throws IOException {
        return new IndexedBamFileParser(bam, bamIndex, ReservedAttributeValidator.INSTANCE);
    }

    public static SamParser createUsingIndex(File bam, File bamIndex, SamAttributeValidator validator) throws IOException {
        IOUtil.verifyIsReadable(bam);
        IOUtil.verifyIsReadable(bamIndex);
        if (validator == null) {
            throw new NullPointerException("validator can not be null");
        }
        return new IndexedBamFileParser(bam, bamIndex, validator);
    }
}

