/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.IOException;
import java.util.Optional;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.header.SamHeader;

public interface SamParser {
    public boolean canParse();

    public void parse(SamVisitor var1) throws IOException;

    public void parse(SamVisitor var1, SamVisitor.SamVisitorCallback.SamVisitorMemento var2) throws IOException;

    public void parse(String var1, SamVisitor var2) throws IOException;

    public void parse(String var1, Range var2, SamVisitor var3) throws IOException;

    public void parse(SamParserOptions var1, SamVisitor var2) throws IOException;

    public SamHeader getHeader() throws IOException;

    public static class SamParserOptions {
        private final boolean createMementos;
        private final String referenceName;
        private final Range referenceRange;

        public SamParserOptions() {
            this(false, null, null);
        }

        private SamParserOptions(boolean createMementos, String referenceName, Range range) {
            this.createMementos = createMementos;
            this.referenceName = referenceName;
            this.referenceRange = range;
        }

        public SamParserOptions reference(String referenceName) {
            return new SamParserOptions(this.createMementos, referenceName, null);
        }

        public SamParserOptions reference(String referenceName, Range referenceRange) {
            return new SamParserOptions(this.createMementos, referenceName, referenceRange);
        }

        public SamParserOptions createMementos(boolean createMementos) {
            return new SamParserOptions(createMementos, this.referenceName, this.referenceRange);
        }

        public boolean shouldCreateMementos() {
            return this.createMementos;
        }

        public Optional<String> getReferenceName() {
            return Optional.ofNullable(this.referenceName);
        }

        public Optional<Range> getReferenceRange() {
            return Optional.ofNullable(this.referenceRange);
        }
    }
}

