/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.internal.sam.index.BamIndexer;
import org.jcvi.jillion.sam.Encoding;
import org.jcvi.jillion.sam.SamWriter;
import org.jcvi.jillion.sam.SortOrder;
import org.jcvi.jillion.sam.attribute.ReservedAttributeValidator;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamHeaderBuilder;

public final class SamFileWriterBuilder {
    private static final int DEFAULT_RECORDS_IN_MEMORY = 2000000;
    private final File outputFile;
    private final SamHeaderBuilder headerBuilder;
    private SamAttributeValidator attributeValidator = ReservedAttributeValidator.INSTANCE;
    private File tmpDirRoot = null;
    private SortOrder reSortOrder = null;
    private int maxRecordsToKeepInMemory = 2000000;
    private boolean makeBamIndex = false;
    private boolean includeIndexMetadata = false;

    public static int getDefaultRecordsToKeepInMemory() {
        return 2000000;
    }

    public SamFileWriterBuilder(File outputFile, SamHeader header) {
        if (outputFile == null) {
            throw new NullPointerException("output file can not be null");
        }
        if (header == null) {
            throw new NullPointerException("headerBuilder can not be null");
        }
        this.outputFile = outputFile;
        this.headerBuilder = new SamHeaderBuilder(header);
    }

    public SamFileWriterBuilder setTempRootDir(File tmpDir) {
        this.tmpDirRoot = tmpDir;
        return this;
    }

    public SamFileWriterBuilder setSamAttributeValidator(SamAttributeValidator validator) {
        if (validator == null) {
            throw new NullPointerException("validator can not be null");
        }
        this.attributeValidator = validator;
        return this;
    }

    public SamFileWriterBuilder createBamIndex(boolean createBamIndex) {
        return this.createBamIndex(createBamIndex, false);
    }

    public SamFileWriterBuilder createBamIndex(boolean createBamIndex, boolean includeMetadata) {
        this.makeBamIndex = createBamIndex;
        this.includeIndexMetadata = includeMetadata;
        return this;
    }

    public SamFileWriterBuilder reSortBy(SortOrder sortOrder) {
        return this.reSortBy(sortOrder, 2000000);
    }

    public SamFileWriterBuilder reSortBy(SortOrder sortOrder, int maxRecordsToKeepInMemory) {
        if (sortOrder == null) {
            throw new NullPointerException("sort order can not be null");
        }
        if (maxRecordsToKeepInMemory < 1) {
            throw new IllegalArgumentException("max records to keep in memory must be positive");
        }
        this.forceHeaderSortOrder(sortOrder);
        this.reSortOrder = sortOrder;
        this.maxRecordsToKeepInMemory = maxRecordsToKeepInMemory;
        return this;
    }

    public SamFileWriterBuilder forceHeaderSortOrder(SortOrder sortOrder) {
        this.headerBuilder.setSortOrder(sortOrder);
        return this;
    }

    public SamWriter build() throws IOException {
        BamIndexer indexer;
        SamHeader header = this.headerBuilder.build();
        Encoding encoding = Encoding.parseEncoding(FileUtil.getExtension(this.outputFile));
        if (this.makeBamIndex && encoding == Encoding.BAM) {
            if (header.getSortOrder() != SortOrder.COORDINATE) {
                throw new IllegalStateException("can not make bam index when bam file to be written is not coordinate sorted");
            }
            indexer = new BamIndexer(header);
        } else {
            indexer = null;
        }
        if (this.writeUnSortedRecords()) {
            return encoding.createPreSortedNoValidationOutputWriter(this.outputFile, header, indexer, this.includeIndexMetadata);
        }
        return encoding.createReSortedOutputWriter(this.outputFile, this.tmpDirRoot, header, this.maxRecordsToKeepInMemory, this.attributeValidator, indexer, this.includeIndexMetadata);
    }

    private boolean writeUnSortedRecords() {
        return this.reSortOrder == null || this.reSortOrder == SortOrder.UNKNOWN || this.reSortOrder == SortOrder.UNSORTED;
    }
}

