/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.core.io.TextLineParser;
import org.jcvi.jillion.internal.sam.SamUtil;
import org.jcvi.jillion.sam.AbstractSamFileParser;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamRecordBuilder;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.attribute.InvalidAttributeException;
import org.jcvi.jillion.sam.attribute.ReservedAttributeValidator;
import org.jcvi.jillion.sam.attribute.ReservedSamAttributeKeys;
import org.jcvi.jillion.sam.attribute.SamAttribute;
import org.jcvi.jillion.sam.attribute.SamAttributeKey;
import org.jcvi.jillion.sam.attribute.SamAttributeKeyFactory;
import org.jcvi.jillion.sam.attribute.SamAttributeType;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.cigar.Cigar;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;

final class SamFileParser
extends AbstractSamFileParser {
    private static final Pattern SPLIT_LINE_PATTERN = Pattern.compile("\t");
    private static final Pattern TYPED_TAG_VALUE_PATTERN = Pattern.compile("([A-Za-z][A-Za-z0-9]):(([AifZHB]):)?(.+)");
    private final File samFile;
    private final SamAttributeValidator validator;

    public SamFileParser(File samFile) throws IOException {
        this(samFile, ReservedAttributeValidator.INSTANCE);
    }

    public SamFileParser(File samFile, SamAttributeValidator validator) throws IOException {
        if (samFile == null) {
            throw new NullPointerException("sam file can not be null");
        }
        if (!"sam".equals(FileUtil.getExtension(samFile))) {
            throw new IllegalArgumentException("must be .sam file" + samFile.getAbsolutePath());
        }
        if (!samFile.exists()) {
            throw new FileNotFoundException(samFile.getAbsolutePath());
        }
        if (!samFile.canRead()) {
            throw new IllegalArgumentException("sam file not readable " + samFile.getAbsolutePath());
        }
        if (validator == null) {
            throw new NullPointerException("validator can not be null");
        }
        this.samFile = samFile;
        this.validator = validator;
    }

    @Override
    public boolean canParse() {
        return true;
    }

    @Override
    public void parse(SamParser.SamParserOptions options, SamVisitor visitor) throws IOException {
        Predicate<SamRecord> predicate = options.getReferenceName().isPresent() ? (options.getReferenceRange().isPresent() ? SamUtil.alignsToReference(options.getReferenceName().get(), options.getReferenceRange().get()) : SamUtil.alignsToReference(options.getReferenceName().get())) : record -> true;
        CallbackSupplier supplier = options.shouldCreateMementos() ? (keepParsing, pos) -> new SamCallback(keepParsing, pos) : (keepParsing, pos) -> new MementoLessSamCallback(keepParsing);
        this.accept(visitor, predicate, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(SamVisitor visitor, SamVisitor.SamVisitorCallback.SamVisitorMemento memento) throws IOException {
        TextLineParser parser;
        block7: {
            Objects.requireNonNull(visitor);
            Objects.requireNonNull(memento);
            if (!(memento instanceof SamFileMemento)) {
                throw new IllegalArgumentException("memento must be for sam files");
            }
            SamFileMemento samMemento = (SamFileMemento)memento;
            if (this != samMemento.parserInstance) {
                throw new IllegalArgumentException("memento must be for this SamParser instance");
            }
            if (samMemento.position == 0L) {
                this.parse(visitor);
                return;
            }
            parser = null;
            try {
                parser = new TextLineParser(this.samFile, samMemento.position);
                AtomicBoolean keepParsing = new AtomicBoolean(true);
                SamCallback callback = new SamCallback(keepParsing, parser.getPosition());
                SamHeader header = this.parseHeader(parser).build();
                visitor.visitHeader(callback, header);
                while (keepParsing.get() && parser.hasNextLine()) {
                    callback = new SamCallback(keepParsing, parser.getPosition());
                    String line = parser.nextLine().trim();
                    if (line.isEmpty()) continue;
                    SamRecord record = this.parseRecord(header, line);
                    visitor.visitRecord(callback, record, null, null);
                }
                if (keepParsing.get()) {
                    visitor.visitEnd();
                    break block7;
                }
                visitor.halted();
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(parser);
                throw throwable;
            }
        }
        IOUtil.closeAndIgnoreErrors((Closeable)parser);
    }

    @Override
    public void parse(String referenceName, SamVisitor visitor) throws IOException {
        this.parse(new SamParser.SamParserOptions().reference(referenceName), visitor);
    }

    @Override
    public void parse(String referenceName, Range alignmentRange, SamVisitor visitor) throws IOException {
        this.parse(new SamParser.SamParserOptions().reference(referenceName, alignmentRange), visitor);
    }

    @Override
    public void parse(SamVisitor visitor) throws IOException {
        this.parse(new SamParser.SamParserOptions(), visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accept(SamVisitor visitor, Predicate<SamRecord> filter, CallbackSupplier callbackSupplier) throws IOException {
        TextLineParser parser;
        block5: {
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            parser = null;
            try {
                parser = new TextLineParser(this.samFile);
                AtomicBoolean keepParsing = new AtomicBoolean(true);
                SamVisitor.SamVisitorCallback callback = callbackSupplier.create(keepParsing, parser.getPosition());
                SamHeader header = this.parseHeader(parser).build();
                visitor.visitHeader(callback, header);
                while (keepParsing.get() && parser.hasNextLine()) {
                    SamRecord record;
                    callback = callbackSupplier.create(keepParsing, parser.getPosition());
                    String line = parser.nextLine().trim();
                    if (line.isEmpty() || !filter.test(record = this.parseRecord(header, line))) continue;
                    visitor.visitRecord(callback, record, null, null);
                }
                if (keepParsing.get()) {
                    visitor.visitEnd();
                    break block5;
                }
                visitor.halted();
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(parser);
                throw throwable;
            }
        }
        IOUtil.closeAndIgnoreErrors((Closeable)parser);
    }

    private SamRecord parseRecord(SamHeader header, String line) throws IOException {
        String[] fields = SPLIT_LINE_PATTERN.split(line);
        if (fields.length < 11) {
            throw new IOException("invalid sam record line : " + line);
        }
        SamRecordBuilder builder = new SamRecordBuilder(header, this.validator);
        builder.setQueryName(fields[0]);
        builder.setFlags(Integer.parseInt(fields[1]));
        builder.setReferenceName(fields[2]);
        builder.setStartPosition(Integer.parseInt(fields[3]));
        builder.setMappingQuality(Byte.parseByte(fields[4]));
        builder.setCigar(Cigar.parse(fields[5]));
        builder.setNextReferenceName(fields[6]);
        builder.setNextPosition(Integer.parseInt(fields[7]));
        builder.setObservedTemplateLength(Integer.parseInt(fields[8]));
        builder.setSequence(SamFileParser.parseSequence(fields[9]));
        builder.setQualities(SamFileParser.parseQualities(fields[10]));
        for (int i = 11; i < fields.length; ++i) {
            Matcher matcher = TYPED_TAG_VALUE_PATTERN.matcher(fields[i]);
            if (matcher.matches()) {
                String key = matcher.group(1);
                String optionalType = matcher.group(3);
                String value = matcher.group(4);
                if (optionalType == null) {
                    ReservedSamAttributeKeys reserved = ReservedSamAttributeKeys.parseKey(key);
                    if (reserved == null) {
                        throw new IOException("unknown optional attribute without type information (not reserved) : " + fields[i]);
                    }
                    try {
                        builder.addAttribute(new SamAttribute(reserved, value));
                        continue;
                    }
                    catch (InvalidAttributeException e) {
                        throw new IOException("invalid attribute value for " + fields[i], e);
                    }
                }
                SamAttributeKey customKey = SamAttributeKeyFactory.getKey(key);
                SamAttributeType type = SamAttributeType.parseType(optionalType.charAt(0), value);
                try {
                    builder.addAttribute(new SamAttribute(customKey, type, value));
                    continue;
                }
                catch (InvalidAttributeException e) {
                    throw new IOException("invalid attribute value for " + fields[i], e);
                }
            }
            throw new IOException("invalid attribute format " + fields[i]);
        }
        return builder.build();
    }

    private static NucleotideSequence parseSequence(String s) {
        if ("*".equals(s)) {
            return null;
        }
        return new NucleotideSequenceBuilder(s).turnOffDataCompression(true).build();
    }

    private static QualitySequence parseQualities(String s) {
        if ("*".equals(s)) {
            return null;
        }
        return FastqQualityCodec.SANGER.decode(s, true);
    }

    private static final class SamFileMemento
    implements SamVisitor.SamVisitorCallback.SamVisitorMemento {
        private final SamFileParser parserInstance;
        private final long position;

        public SamFileMemento(SamFileParser parserInstance, long position) {
            this.parserInstance = parserInstance;
            this.position = position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parserInstance == null ? 0 : this.parserInstance.hashCode());
            result = 31 * result + (int)(this.position ^ this.position >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SamFileMemento)) {
                return false;
            }
            SamFileMemento other = (SamFileMemento)obj;
            if (this.parserInstance != other.parserInstance) {
                return false;
            }
            return this.position == other.position;
        }
    }

    private final class SamCallback
    extends AbstractSamFileParser.AbstractCallback {
        private final long currentPosition;

        public SamCallback(AtomicBoolean keepParsing, long currentPosition) {
            super(keepParsing);
            this.currentPosition = currentPosition;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public SamVisitor.SamVisitorCallback.SamVisitorMemento createMemento() {
            return new SamFileMemento(SamFileParser.this, this.currentPosition);
        }
    }

    private final class MementoLessSamCallback
    extends AbstractSamFileParser.AbstractCallback {
        public MementoLessSamCallback(AtomicBoolean keepParsing) {
            super(keepParsing);
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public SamVisitor.SamVisitorCallback.SamVisitorMemento createMemento() {
            throw new UnsupportedOperationException();
        }
    }

    @FunctionalInterface
    private static interface CallbackSupplier {
        public SamVisitor.SamVisitorCallback create(AtomicBoolean var1, long var2);
    }
}

