/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.sam.DefaultSamFileDataStore;
import org.jcvi.jillion.sam.QuerySortedSamFileDataStore;
import org.jcvi.jillion.sam.SamFileDataStore;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamParserFactory;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SortOrder;
import org.jcvi.jillion.sam.attribute.ReservedAttributeValidator;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.header.SamHeader;

public final class SamFileDataStoreBuilder {
    private final File samFile;
    private File baiFile;
    private SamAttributeValidator validator = ReservedAttributeValidator.INSTANCE;
    private Predicate<SamRecord> filter;

    public SamFileDataStoreBuilder(File samFile) throws IOException {
        IOUtil.verifyIsReadable(samFile);
        this.samFile = samFile;
    }

    public SamFileDataStoreBuilder indexFile(File baiFile) throws IOException {
        IOUtil.verifyIsReadable(baiFile);
        this.baiFile = baiFile;
        return this;
    }

    public SamFileDataStoreBuilder validator(SamAttributeValidator validator) {
        Objects.requireNonNull(validator);
        this.validator = validator;
        return this;
    }

    public SamFileDataStoreBuilder filter(Predicate<SamRecord> filter) {
        Objects.requireNonNull(filter);
        this.filter = filter;
        return this;
    }

    public SamFileDataStore build() throws IOException {
        SamParser parser = this.baiFile == null ? SamParserFactory.create(this.samFile, this.validator) : SamParserFactory.createUsingIndex(this.samFile, this.baiFile, this.validator);
        SamHeader header = parser.getHeader();
        if (SortOrder.QUERY_NAME.equals((Object)header.getSortOrder())) {
            return new QuerySortedSamFileDataStore(parser, this.filter);
        }
        return new DefaultSamFileDataStore(parser, this.filter);
    }
}

