/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.streams.ThrowingConsumer;
import org.jcvi.jillion.sam.SamFileDataStoreBuilder;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.header.SamHeader;

public interface SamFileDataStore
extends DataStore<SamRecord> {
    public static SamFileDataStore fromFile(File samOrBamFile) throws IOException {
        return new SamFileDataStoreBuilder(samOrBamFile).build();
    }

    @Override
    public SamRecord get(String var1) throws DataStoreException;

    public List<SamRecord> getAllRecordsFor(String var1) throws DataStoreException;

    public SamHeader getHeader() throws DataStoreException;

    public StreamingIterator<SamRecord> getAlignedRecords(String var1) throws DataStoreException;

    public <E extends Throwable> void forEachAlignedRecord(String var1, ThrowingConsumer<SamRecord, E> var2) throws DataStoreException, E;

    public <E extends Throwable> void forEachAlignedRecord(String var1, Range var2, ThrowingConsumer<SamRecord, E> var3) throws DataStoreException, E;

    default public <E extends Throwable> void forEachAlignedRecord(String referenceName, Collection<Range> alignmentRanges, ThrowingConsumer<SamRecord, E> consumer) throws DataStoreException, E {
        for (Range r : alignmentRanges) {
            this.forEachAlignedRecord(referenceName, r, consumer);
        }
    }

    public StreamingIterator<SamRecord> getAlignedRecords(String var1, Range var2) throws DataStoreException;

    default public StreamingIterator<SamRecord> getAlignedRecords(String referenceName, Range ... alignmentRanges) throws DataStoreException {
        ArrayList<Supplier<StreamingIterator>> suppliers = new ArrayList<Supplier<StreamingIterator>>(alignmentRanges.length);
        for (Range r : alignmentRanges) {
            Objects.requireNonNull(r, "range can not be null");
            suppliers.add(() -> {
                try {
                    return this.getAlignedRecords(referenceName, r);
                }
                catch (DataStoreException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        return IteratorUtil.chainStreamingSuppliers(suppliers);
    }
}

