/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.PeekableStreamingIterator;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;
import org.jcvi.jillion.internal.sam.index.BamIndexer;
import org.jcvi.jillion.sam.Encoding;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamValidationException;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.SamWriter;
import org.jcvi.jillion.sam.SortOrder;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.header.SamHeader;

class ReSortSamFileWriter
implements SamWriter {
    private final SamHeader header;
    private final Comparator<SamRecord> recordComparator;
    private final File tmpDir;
    private final File outputFile;
    private SamRecord[] inMemoryArray;
    private int currentInMemSize;
    private final int maxRecordsToKeepInMemory;
    private final List<File> tempFiles = new ArrayList<File>();
    private final SamAttributeValidator attributeValidator;
    private final Encoding encoding;
    private final BamIndexer indexer;
    private final boolean includeIndexMetaData;

    ReSortSamFileWriter(File outputFile, File tmpDirRoot, SamHeader header, int maxRecordsToKeepInMemory, SamAttributeValidator attributeValidator, Encoding encodingToUse, BamIndexer indexer, boolean includeIndexMetaData) throws IOException {
        if (maxRecordsToKeepInMemory < 0) {
            throw new IllegalArgumentException("max records to keep in memory must be >=1");
        }
        if (attributeValidator == null) {
            throw new NullPointerException("attribute valiator can not be null");
        }
        if (encodingToUse == null) {
            throw new NullPointerException("Encoding can not be null");
        }
        this.maxRecordsToKeepInMemory = maxRecordsToKeepInMemory;
        this.header = header;
        this.recordComparator = ReSortSamFileWriter.createRecordComparatorFor(header);
        if (this.recordComparator == null) {
            throw new NullPointerException("SortOrder must create a non-null comparator " + (Object)((Object)header.getSortOrder()));
        }
        IOUtil.mkdirs(outputFile.getParentFile());
        this.tmpDir = IOUtil.createTempDir("jillion", "samWriterTmp", tmpDirRoot);
        this.inMemoryArray = new SamRecord[maxRecordsToKeepInMemory];
        this.currentInMemSize = 0;
        this.outputFile = outputFile;
        this.attributeValidator = attributeValidator;
        this.encoding = encodingToUse;
        this.indexer = indexer;
        this.includeIndexMetaData = includeIndexMetaData;
    }

    private static Comparator<SamRecord> createRecordComparatorFor(SamHeader header) {
        SortOrder sortOrder = header.getSortOrder();
        if (sortOrder == null) {
            return null;
        }
        return sortOrder.createComparator(header);
    }

    @Override
    public void writeRecord(SamRecord record) throws IOException {
        if (record == null) {
            throw new NullPointerException("record can not be null");
        }
        this.persistInMemoryCacheIfNeeded();
        try {
            this.header.validateRecord(record, this.attributeValidator);
        }
        catch (SamValidationException e) {
            throw new IOException("can not write record due to validation error(s)", e);
        }
        this.inMemoryArray[this.currentInMemSize++] = record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistInMemoryCacheIfNeeded() throws IOException {
        if (this.currentInMemSize == this.maxRecordsToKeepInMemory) {
            this.sortInMemoryRecords();
            File tempFile = File.createTempFile(this.outputFile.getName(), this.encoding.getSuffix(), this.tmpDir);
            this.tempFiles.add(tempFile);
            SamWriter writer = this.encoding.createPreSortedNoValidationOutputWriter(tempFile, this.header, null, false);
            try {
                for (int i = 0; i < this.currentInMemSize; ++i) {
                    writer.writeRecord(this.inMemoryArray[i]);
                }
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)writer);
                this.clearInMemoryArray();
            }
        }
    }

    private void clearInMemoryArray() {
        this.currentInMemSize = 0;
        Arrays.fill(this.inMemoryArray, null);
    }

    private void sortInMemoryRecords() {
        Arrays.sort(this.inMemoryArray, this.recordComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<PeekableStreamingIterator<SamRecord>> iterators = new ArrayList<PeekableStreamingIterator<SamRecord>>(1 + this.tempFiles.size());
        SamWriter writer = null;
        try {
            this.sortInMemoryRecords();
            iterators.add(IteratorUtil.createPeekableStreamingIterator(new InMemoryStreamingIterator(this.currentInMemSize)));
            for (File file : this.tempFiles) {
                iterators.add(IteratorUtil.createPeekableStreamingIterator(new StreamingSamRecordIterator(file, this.encoding)));
            }
            MergedSortedRecordIterator sortedIterator = new MergedSortedRecordIterator(iterators, this.recordComparator);
            writer = this.encoding.createPreSortedNoValidationOutputWriter(this.outputFile, this.header, this.indexer, this.includeIndexMetaData);
            while (sortedIterator.hasNext()) {
                writer.writeRecord((SamRecord)sortedIterator.next());
            }
        }
        catch (Throwable throwable) {
            for (StreamingIterator streamingIterator : iterators) {
                IOUtil.closeAndIgnoreErrors((Closeable)streamingIterator);
            }
            IOUtil.closeAndIgnoreErrors(writer);
            this.clearInMemoryArray();
            IOUtil.recursiveDelete(this.tmpDir);
            throw throwable;
        }
        for (StreamingIterator streamingIterator : iterators) {
            IOUtil.closeAndIgnoreErrors((Closeable)streamingIterator);
        }
        IOUtil.closeAndIgnoreErrors((Closeable)writer);
        this.clearInMemoryArray();
        IOUtil.recursiveDelete(this.tmpDir);
    }

    private static class StreamingSamRecordIterator
    extends AbstractBlockingStreamingIterator<SamRecord> {
        private final File samFile;
        private final Encoding encoding;

        public StreamingSamRecordIterator(File samFile, Encoding encoding) {
            this.samFile = samFile;
            this.encoding = encoding;
            this.start();
        }

        @Override
        protected void backgroundThreadRunMethod() throws RuntimeException {
            try {
                this.encoding.createNewNoValidationSamParser(this.samFile).parse(new SamVisitor(){

                    @Override
                    public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                        this.blockingPut(record);
                    }

                    @Override
                    public void visitHeader(SamVisitor.SamVisitorCallback callback, SamHeader header) {
                    }

                    @Override
                    public void visitEnd() {
                    }

                    @Override
                    public void halted() {
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("error parsing temp sam file " + this.samFile.getAbsolutePath(), e);
            }
        }
    }

    private static class SortedSamRecordElementComparator
    implements Comparator<SortedSamRecordElement> {
        private final Comparator<SamRecord> comparator;

        public SortedSamRecordElementComparator(Comparator<SamRecord> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(SortedSamRecordElement o1, SortedSamRecordElement o2) {
            return this.comparator.compare(o1.record, o2.record);
        }
    }

    private static class SortedSamRecordElement {
        SamRecord record;
        Iterator<SamRecord> source;

        public SortedSamRecordElement(SamRecord record, Iterator<SamRecord> source) {
            this.record = record;
            this.source = source;
        }

        public String toString() {
            return "SortedSamRecordElement [record=" + this.record + ", source=" + this.source + "]";
        }
    }

    public static class MergedSortedRecordIterator
    implements Iterator<SamRecord> {
        private final List<PeekableStreamingIterator<SamRecord>> iterators;
        private SamRecord next;
        private final SortedSamRecordElementComparator comparator;
        private final List<SortedSamRecordElement> elementList;

        public MergedSortedRecordIterator(List<PeekableStreamingIterator<SamRecord>> iterators, Comparator<SamRecord> comparator) {
            this.iterators = iterators;
            this.comparator = new SortedSamRecordElementComparator(comparator);
            this.elementList = new ArrayList<SortedSamRecordElement>(iterators.size());
            this.next = this.getNext();
        }

        private SamRecord getNext() {
            this.elementList.clear();
            for (PeekableStreamingIterator<SamRecord> iter : this.iterators) {
                if (!iter.hasNext()) continue;
                this.elementList.add(new SortedSamRecordElement((SamRecord)iter.peek(), iter));
            }
            if (this.elementList.isEmpty()) {
                return null;
            }
            Collections.sort(this.elementList, this.comparator);
            SortedSamRecordElement element = this.elementList.get(0);
            element.source.next();
            return element.record;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SamRecord next() {
            SamRecord ret = this.next;
            this.next = this.getNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InMemoryStreamingIterator
    implements StreamingIterator<SamRecord> {
        private final int length;
        private int counter = 0;

        InMemoryStreamingIterator(int numOfInMemoryRecords) {
            this.length = numOfInMemoryRecords;
        }

        @Override
        public boolean hasNext() {
            return this.counter < this.length;
        }

        @Override
        public void close() {
        }

        @Override
        public SamRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ReSortSamFileWriter.this.inMemoryArray[this.counter++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

