/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.internal.sam.SamUtil;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamRecordFlags;
import org.jcvi.jillion.sam.SamValidationException;
import org.jcvi.jillion.sam.SamWriter;
import org.jcvi.jillion.sam.attribute.SamAttribute;
import org.jcvi.jillion.sam.attribute.SamAttributeKey;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;

class PresortedSamFileWriter
implements SamWriter {
    private static final char UNUSED_FIELD = '*';
    private static final char NULL_CHAR = '0';
    private static final char TAB = '\t';
    private final PrintStream out;
    private final SamHeader header;
    private final SamAttributeValidator attributeValidator;

    public PresortedSamFileWriter(File out, SamHeader header, SamAttributeValidator attributeValidator) throws IOException {
        if (out == null) {
            throw new NullPointerException("output stream can not be null");
        }
        if (header == null) {
            throw new NullPointerException("header can not be null");
        }
        if (attributeValidator == null) {
            throw new NullPointerException("header can not be null");
        }
        IOUtil.mkdirs(out.getParentFile());
        this.out = new PrintStream(out, "UTF-8");
        this.header = header;
        this.attributeValidator = attributeValidator;
        this.out.print(SamUtil.encodeHeader(this.header).toString());
    }

    private void appendMandatoryField(StringBuilder builder, Integer value) {
        builder.append('\t');
        if (value == null) {
            builder.append('0');
        } else {
            builder.append(value);
        }
    }

    private void appendMandatoryField(StringBuilder builder, Object value) {
        this.appendMandatoryField(builder, value, false);
    }

    private void appendMandatoryField(StringBuilder builder, Object value, boolean firstField) {
        if (!firstField) {
            builder.append('\t');
        }
        if (value == null) {
            builder.append('*');
        } else {
            builder.append(value);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void writeRecord(SamRecord record) throws IOException {
        try {
            this.header.validateRecord(record, this.attributeValidator);
        }
        catch (SamValidationException e) {
            throw new IOException("can not write record due to validation error(s)", e);
        }
        StringBuilder builder = new StringBuilder(4096);
        this.appendMandatoryField(builder, record.getQueryName(), true);
        SamRecordFlags flags = record.getFlags();
        if (flags == null) {
            this.appendMandatoryField(builder, null);
        } else {
            this.appendMandatoryField(builder, flags.asInt());
        }
        this.appendMandatoryField(builder, record.getReferenceName());
        this.appendMandatoryField(builder, record.getStartPosition());
        this.appendMandatoryField(builder, Math.max(0, record.getMappingQuality()));
        this.appendMandatoryField(builder, record.getCigar());
        this.appendMandatoryField(builder, record.getNextName());
        this.appendMandatoryField(builder, record.getNextOffset());
        this.appendMandatoryField(builder, record.getObservedTemplateLength());
        this.appendMandatoryField(builder, record.getSequence());
        QualitySequence quals = record.getQualities();
        this.appendMandatoryField(builder, quals == null ? null : FastqQualityCodec.SANGER.encode(quals));
        for (SamAttribute attr : record.getAttributes()) {
            SamAttributeKey key = attr.getKey();
            builder.append('\t').append(key.toString()).append(':').append(attr.getType().getTextTypeCode()).append(attr.getType().textEncode(attr.getValue()));
        }
        this.out.printf("%s%n", builder.toString());
    }
}

