/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.sam.SamUtil;
import org.jcvi.jillion.internal.sam.index.BamIndexer;
import org.jcvi.jillion.internal.sam.index.IndexUtil;
import org.jcvi.jillion.sam.BgzfOutputStream;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamValidationException;
import org.jcvi.jillion.sam.SamWriter;
import org.jcvi.jillion.sam.attribute.ReservedAttributeValidator;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamReferenceSequence;
import org.jcvi.jillion.sam.index.BamIndex;

class PresortedBamFileWriter
implements SamWriter {
    private final SamHeader header;
    private final File bamFile;
    private final OutputStream out;
    private final SamAttributeValidator attributeValidator;
    private final BamIndexer optionalIndexer;
    private boolean closed = false;
    private final boolean includeIndexMetaData;
    private Map<String, Integer> refSeqIndexMap = new HashMap<String, Integer>();

    public PresortedBamFileWriter(SamHeader header, File outputFile, BamIndexer optionalIndexer, boolean includeIndexMetaData) throws IOException {
        this(header, outputFile, optionalIndexer, ReservedAttributeValidator.INSTANCE, includeIndexMetaData);
    }

    public PresortedBamFileWriter(SamHeader header, File outputFile, BamIndexer optionalIndexer, SamAttributeValidator attributeValidator, boolean includeIndexMetaData) throws IOException {
        this.header = header;
        this.bamFile = outputFile;
        this.attributeValidator = attributeValidator;
        this.optionalIndexer = optionalIndexer;
        this.includeIndexMetaData = includeIndexMetaData;
        this.out = new BgzfOutputStream(this.bamFile, optionalIndexer);
        int i = 0;
        for (SamReferenceSequence refSeq : header.getReferenceSequences()) {
            this.refSeqIndexMap.put(refSeq.getName(), i);
            ++i;
        }
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        StringBuilder headerAsStringBuilder = SamUtil.encodeHeader(this.header);
        int bytesOfReferences = 4;
        for (SamReferenceSequence ref : this.header.getReferenceSequences()) {
            bytesOfReferences += ref.getName().length() + 1 + 8;
        }
        ByteBuffer buf = ByteBuffer.allocate(8 + headerAsStringBuilder.length() + bytesOfReferences);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(SamUtil.getBamMagicNumber());
        buf.putInt(headerAsStringBuilder.length());
        char[] chars = new char[headerAsStringBuilder.length()];
        headerAsStringBuilder.getChars(0, chars.length, chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            buf.put((byte)chars[i]);
        }
        Collection<SamReferenceSequence> refs = this.header.getReferenceSequences();
        buf.putInt(refs.size());
        for (SamReferenceSequence ref : refs) {
            buf.putInt(ref.getName().length() + 1);
            buf.put(ref.getName().getBytes(IOUtil.UTF_8));
            buf.put((byte)0);
            buf.putInt(ref.getLength());
        }
        buf.flip();
        this.out.write(buf.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.out.close();
        if (this.optionalIndexer != null) {
            BamIndex bamIndex = this.optionalIndexer.createBamIndex();
            File indexFileOutFile = new File(this.bamFile.getParentFile(), this.bamFile.getName() + ".bai");
            BufferedOutputStream indexOutStream = null;
            try {
                indexOutStream = new BufferedOutputStream(new FileOutputStream(indexFileOutFile));
                IndexUtil.writeIndex(indexOutStream, bamIndex, this.includeIndexMetaData);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(indexOutStream);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)indexOutStream);
        }
    }

    @Override
    public void writeRecord(SamRecord record) throws IOException {
        try {
            this.header.validateRecord(record, this.attributeValidator);
        }
        catch (SamValidationException e) {
            throw new IOException("can not write record due to validation error(s)", e);
        }
        if (this.optionalIndexer != null) {
            this.optionalIndexer.setCurrentRecord(record);
        }
        SamUtil.writeAsBamRecord(this.out, this.header, record, this.getRefIndexFor(record.getReferenceName()), this.getRefIndexFor(record.getNextName()));
    }

    private int getRefIndexFor(String refName) {
        Integer refIndex = this.refSeqIndexMap.get(refName);
        if (refIndex == null) {
            return -1;
        }
        return refIndex;
    }
}

