/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.internal.sam.SamUtil;
import org.jcvi.jillion.internal.sam.index.IndexUtil;
import org.jcvi.jillion.sam.BamFileParser;
import org.jcvi.jillion.sam.BgzfInputStream;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.index.BamIndex;
import org.jcvi.jillion.sam.index.ReferenceIndex;

class IndexedBamFileParser
extends BamFileParser {
    private final BamIndex index;
    private static VirtualFileOffset BEGINING_OF_FILE = new VirtualFileOffset(0L);

    public IndexedBamFileParser(File bamFile, File baiFile, SamAttributeValidator validator) throws IOException {
        super(bamFile, validator);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(baiFile));){
            this.index = IndexUtil.parseIndex(in, this.getHeader());
        }
    }

    @Override
    protected void _parse(String referenceName, boolean shouldCreateMementos, SamVisitor visitor) throws IOException {
        Objects.requireNonNull(referenceName);
        Objects.requireNonNull(visitor);
        Integer indexOffset = this.index.getReferenceIndexOffset(referenceName);
        if (indexOffset == null) {
            throw new IllegalArgumentException("no reference with name '" + referenceName + "'");
        }
        ReferenceIndex refIndex = this.index.getReferenceIndex(indexOffset);
        VirtualFileOffset start = refIndex.getLowestStartOffset();
        VirtualFileOffset end = refIndex.getHighestEndOffset();
        Predicate<SamRecord> recordMatchPredicate = record -> referenceName.equals(record.getReferenceName());
        Predicate<VirtualFileOffset> endPredicate = vfs -> vfs.compareTo(end) < 0;
        try (BgzfInputStream in = BgzfInputStream.create(this.bamFile, start);){
            if (BEGINING_OF_FILE.equals(start)) {
                this.parseBamFromBeginning(visitor, shouldCreateMementos, recordMatchPredicate, endPredicate, in);
            } else {
                AtomicBoolean keepParsing = new AtomicBoolean(true);
                this.parseBamRecords(visitor, recordMatchPredicate, endPredicate, in, keepParsing, shouldCreateMementos ? new BamFileParser.BamCallback(this, keepParsing) : new BamFileParser.MementoLessBamCallback(this, keepParsing));
            }
        }
    }

    @Override
    protected void _parse(String referenceName, Range alignmentRange, boolean shouldCreateMementos, SamVisitor visitor) throws IOException {
        Objects.requireNonNull(referenceName);
        Objects.requireNonNull(visitor);
        ReferenceIndex refIndex = this.index.getReferenceIndex(referenceName);
        if (refIndex == null) {
            throw new IllegalArgumentException("no reference with name '" + referenceName + "'");
        }
        int[] overlappingBins = SamUtil.getCandidateOverlappingBins(alignmentRange);
        VirtualFileOffset start = refIndex.getLowestStartOffset();
        VirtualFileOffset end = refIndex.getHighestEndOffset();
        Predicate<SamRecord> recordBinFilter = record -> {
            if (!referenceName.equals(record.getReferenceName())) {
                return false;
            }
            Range readAlignmentRange = record.getAlignmentRange();
            int bin = SamUtil.computeBinFor(readAlignmentRange);
            if (Arrays.binarySearch(overlappingBins, bin) < 0) {
                return false;
            }
            return readAlignmentRange.isSubRangeOf(alignmentRange);
        };
        try (BgzfInputStream in = BgzfInputStream.create(this.bamFile, start);){
            AtomicBoolean keepParsing = new AtomicBoolean(true);
            this.parseBamRecords(visitor, recordBinFilter, vfs -> vfs.compareTo(end) <= 0, in, keepParsing, shouldCreateMementos ? new BamFileParser.BamCallback(this, keepParsing) : new BamFileParser.MementoLessBamCallback(this, keepParsing));
        }
    }
}

