/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.internal.sam.index.BamIndexer;
import org.jcvi.jillion.sam.BamFileParser;
import org.jcvi.jillion.sam.NullSamAttributeValidator;
import org.jcvi.jillion.sam.PresortedBamFileWriter;
import org.jcvi.jillion.sam.PresortedSamFileWriter;
import org.jcvi.jillion.sam.ReSortSamFileWriter;
import org.jcvi.jillion.sam.SamFileParser;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamWriter;
import org.jcvi.jillion.sam.attribute.SamAttributeValidator;
import org.jcvi.jillion.sam.header.SamHeader;

enum Encoding {
    SAM(".sam"){

        @Override
        SamWriter createPreSortedOutputWriter(File out, SamHeader header, SamAttributeValidator validator, BamIndexer indexer, boolean includeIndexMetaData) throws IOException {
            return new PresortedSamFileWriter(out, header, validator);
        }

        @Override
        SamParser createNewNoValidationSamParser(File f) throws IOException {
            return new SamFileParser(f, NullSamAttributeValidator.INSTANCE);
        }
    }
    ,
    BAM(".bam"){

        @Override
        SamWriter createPreSortedOutputWriter(File out, SamHeader header, SamAttributeValidator validator, BamIndexer indexer, boolean includeIndexMetaData) throws IOException {
            return new PresortedBamFileWriter(header, out, indexer, validator, includeIndexMetaData);
        }

        @Override
        SamParser createNewNoValidationSamParser(File f) throws IOException {
            return new BamFileParser(f, NullSamAttributeValidator.INSTANCE);
        }
    };

    private final String suffix;

    private Encoding(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    SamWriter createPreSortedNoValidationOutputWriter(File out, SamHeader header, BamIndexer indexer, boolean includeIndexMetaData) throws IOException {
        return this.createPreSortedOutputWriter(out, header, NullSamAttributeValidator.INSTANCE, indexer, includeIndexMetaData);
    }

    abstract SamParser createNewNoValidationSamParser(File var1) throws IOException;

    abstract SamWriter createPreSortedOutputWriter(File var1, SamHeader var2, SamAttributeValidator var3, BamIndexer var4, boolean var5) throws IOException;

    SamWriter createReSortedOutputWriter(File out, File tmpDirRoot, SamHeader header, int maxRecordsToKeepInMemory, SamAttributeValidator validator, BamIndexer indexer, boolean includeIndexMetaData) throws IOException {
        return new ReSortSamFileWriter(out, tmpDirRoot, header, maxRecordsToKeepInMemory, validator, this, indexer, includeIndexMetaData);
    }

    static Encoding parseEncoding(String extension) {
        if ("bam".equalsIgnoreCase(extension)) {
            return BAM;
        }
        return SAM;
    }
}

