/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.streams.ThrowingBiConsumer;
import org.jcvi.jillion.core.util.streams.ThrowingConsumer;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.Sneak;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;
import org.jcvi.jillion.sam.AbstractSamVisitor;
import org.jcvi.jillion.sam.SamFileDataStore;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamRecord;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.VirtualFileOffset;
import org.jcvi.jillion.sam.header.SamHeader;

class DefaultSamFileDataStore
implements SamFileDataStore {
    protected final SamParser parser;
    private final Predicate<SamRecord> filter;
    private volatile boolean isClosed;
    private long numRecords = -1L;

    DefaultSamFileDataStore(SamParser parser, Predicate<SamRecord> filter) {
        this.parser = parser;
        this.filter = filter;
    }

    private void verifyNotClosed() throws DataStoreException {
        if (this.isClosed) {
            throw new DataStoreException("closed");
        }
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.verifyNotClosed();
        return new StreamingIterator<String>(){
            StreamingIterator<SamRecord> iter;
            {
                this.iter = DefaultSamFileDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void close() {
                this.iter.close();
            }

            @Override
            public String next() {
                SamRecord next = this.iter.next();
                return next.getQueryName();
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public SamRecord get(String id) throws DataStoreException {
        this.verifyNotClosed();
        Objects.requireNonNull(id);
        try {
            SamRecord found = this.getRecord(id);
            if (found == null || this.filter != null && !this.filter.test(found)) {
                return null;
            }
            return found;
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing sam/bam file to find record with id '" + id + "'", e);
        }
    }

    @Override
    public List<SamRecord> getAllRecordsFor(String id) throws DataStoreException {
        this.verifyNotClosed();
        Objects.requireNonNull(id);
        try {
            List<SamRecord> found = this.getAllRecord(id);
            ArrayList<SamRecord> filtered = new ArrayList<SamRecord>(found.size());
            for (SamRecord r : found) {
                if (found == null || this.filter != null && !this.filter.test(r)) continue;
                filtered.add(r);
            }
            return filtered;
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing sam/bam file to find record with id '" + id + "'", e);
        }
    }

    protected SamRecord getRecord(final String id) throws IOException {
        final SamRecord[] ret = new SamRecord[1];
        this.parser.parse(new AbstractSamVisitor(){

            @Override
            public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                if (id.equals(record.getQueryName())) {
                    ret[0] = record;
                    callback.haltParsing();
                }
            }
        });
        return ret[0];
    }

    protected List<SamRecord> getAllRecord(final String id) throws IOException {
        final ArrayList<SamRecord> ret = new ArrayList<SamRecord>();
        this.parser.parse(new AbstractSamVisitor(){

            @Override
            public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                if (id.equals(record.getQueryName())) {
                    ret.add(record);
                }
            }
        });
        return ret;
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        return this.get(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.verifyNotClosed();
        DefaultSamFileDataStore defaultSamFileDataStore = this;
        synchronized (defaultSamFileDataStore) {
            if (this.numRecords == -1L) {
                try {
                    this.parser.parse(new AbstractSamVisitor(){
                        long count = 0L;

                        @Override
                        public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                            ++this.count;
                        }

                        @Override
                        public void visitEnd() {
                            DefaultSamFileDataStore.this.numRecords = this.count;
                        }
                    });
                }
                catch (IOException e) {
                    throw new DataStoreException("error counting number of records", e);
                }
            }
            return this.numRecords;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public StreamingIterator<SamRecord> iterator() throws DataStoreException {
        this.verifyNotClosed();
        FilteredVisitor iter = new FilteredVisitor();
        iter.start();
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public StreamingIterator<DataStoreEntry<SamRecord>> entryIterator() throws DataStoreException {
        this.verifyNotClosed();
        return new StreamingIterator<DataStoreEntry<SamRecord>>(){
            StreamingIterator<SamRecord> iter;
            {
                this.iter = DefaultSamFileDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void close() {
                this.iter.close();
            }

            @Override
            public DataStoreEntry<SamRecord> next() {
                SamRecord next = this.iter.next();
                return new DataStoreEntry<SamRecord>(next.getQueryName(), next);
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public SamHeader getHeader() throws DataStoreException {
        this.verifyNotClosed();
        try {
            return this.parser.getHeader();
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing sam/bam file to get header", e);
        }
    }

    @Override
    public <E extends Throwable> void forEachAlignedRecord(String referenceName, final ThrowingConsumer<SamRecord, E> consumer) throws DataStoreException, E {
        Objects.requireNonNull(referenceName);
        Objects.requireNonNull(consumer);
        this.verifyNotClosed();
        try {
            this.parser.parse(referenceName, (SamVisitor)new AbstractSamVisitor(){

                @Override
                public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                    if (DefaultSamFileDataStore.this.filter != null && !DefaultSamFileDataStore.this.filter.test(record)) {
                        return;
                    }
                    try {
                        consumer.accept(record);
                    }
                    catch (Throwable t) {
                        Sneak.sneakyThrow(t);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing sam/bam file to get header", e);
        }
    }

    @Override
    public <E extends Throwable> void forEach(final ThrowingBiConsumer<String, SamRecord, E> consumer) throws IOException, E {
        Objects.requireNonNull(consumer);
        this.verifyNotClosed();
        try {
            this.parser.parse(new AbstractSamVisitor(){

                @Override
                public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                    if (DefaultSamFileDataStore.this.filter != null && !DefaultSamFileDataStore.this.filter.test(record)) {
                        return;
                    }
                    try {
                        consumer.accept(record.getQueryName(), record);
                    }
                    catch (Throwable t) {
                        Sneak.sneakyThrow(t);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing sam/bam file to get header", e);
        }
    }

    @Override
    public <E extends Throwable> void forEachAlignedRecord(String referenceName, Range alignmentRange, final ThrowingConsumer<SamRecord, E> consumer) throws DataStoreException, E {
        Objects.requireNonNull(referenceName);
        Objects.requireNonNull(alignmentRange);
        this.verifyNotClosed();
        try {
            this.parser.parse(referenceName, alignmentRange, new AbstractSamVisitor(){

                @Override
                public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                    if (DefaultSamFileDataStore.this.filter != null && !DefaultSamFileDataStore.this.filter.test(record)) {
                        return;
                    }
                    try {
                        consumer.accept(record);
                    }
                    catch (Throwable t) {
                        Sneak.sneakyThrow(t);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing sam/bam file to get header", e);
        }
    }

    @Override
    public StreamingIterator<SamRecord> getAlignedRecords(String referenceName) throws DataStoreException {
        Objects.requireNonNull(referenceName);
        this.verifyNotClosed();
        this.verifyValidReference(referenceName);
        SingleReferenceFilteredVisitor iter = new SingleReferenceFilteredVisitor(referenceName);
        iter.start();
        return DataStoreStreamingIterator.create(this, iter);
    }

    private void verifyValidReference(String referenceName) throws DataStoreException {
        if (this.getHeader().getReferenceSequence(referenceName) == null) {
            throw new DataStoreException("no reference with name '" + referenceName + "'");
        }
    }

    @Override
    public StreamingIterator<SamRecord> getAlignedRecords(String referenceName, Range alignmentRange) throws DataStoreException {
        Objects.requireNonNull(referenceName);
        Objects.requireNonNull(alignmentRange);
        this.verifyNotClosed();
        SingleReferenceAndRangeFilteredVisitor iter = new SingleReferenceAndRangeFilteredVisitor(referenceName, alignmentRange);
        iter.start();
        return DataStoreStreamingIterator.create(this, iter);
    }

    private class SingleReferenceAndRangeFilteredVisitor
    extends AbstractBlockingStreamingIterator<SamRecord> {
        private final String refname;
        private final Range range;

        protected SingleReferenceAndRangeFilteredVisitor(String refname, Range range) {
            this.refname = refname;
            this.range = range;
        }

        @Override
        protected void backgroundThreadRunMethod() throws RuntimeException {
            try {
                DefaultSamFileDataStore.this.parser.parse(this.refname, this.range, new AbstractSamVisitor(){

                    @Override
                    public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                        if (DefaultSamFileDataStore.this.filter != null && !DefaultSamFileDataStore.this.filter.test(record)) {
                            return;
                        }
                        SingleReferenceAndRangeFilteredVisitor.this.blockingPut(record);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("error parsing sam/bam file", e);
            }
        }
    }

    private class SingleReferenceFilteredVisitor
    extends AbstractBlockingStreamingIterator<SamRecord> {
        private final String refname;

        protected SingleReferenceFilteredVisitor(String refname) {
            this.refname = refname;
        }

        @Override
        protected void backgroundThreadRunMethod() throws RuntimeException {
            try {
                DefaultSamFileDataStore.this.parser.parse(this.refname, (SamVisitor)new AbstractSamVisitor(){

                    @Override
                    public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                        if (DefaultSamFileDataStore.this.filter != null && !DefaultSamFileDataStore.this.filter.test(record)) {
                            return;
                        }
                        SingleReferenceFilteredVisitor.this.blockingPut(record);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("error parsing sam/bam file", e);
            }
        }
    }

    private class FilteredVisitor
    extends AbstractBlockingStreamingIterator<SamRecord> {
        private FilteredVisitor() {
        }

        @Override
        protected void backgroundThreadRunMethod() throws RuntimeException {
            try {
                DefaultSamFileDataStore.this.parser.parse(new AbstractSamVisitor(){

                    @Override
                    public void visitRecord(SamVisitor.SamVisitorCallback callback, SamRecord record, VirtualFileOffset start, VirtualFileOffset end) {
                        if (DefaultSamFileDataStore.this.filter != null && !DefaultSamFileDataStore.this.filter.test(record)) {
                            return;
                        }
                        FilteredVisitor.this.blockingPut(record);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("error parsing sam/bam file", e);
            }
        }
    }
}

