/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.sam.IndexerCallback;
import org.jcvi.jillion.sam.VirtualFileOffset;

final class BgzfOutputStream
extends OutputStream {
    private static final int MAX_COMPRESSED_BLOCK_SIZE = 65536;
    private static final int BGZF_BLOCK_FULL_HEADER_LENGTH = 26;
    private static final int MAX_UNCOMPRESSED_BLOCK_SIZE = 65510;
    private static final int GZIP_COMPRESSION_LEVEL = 5;
    private static final byte[] BGZF_BLOCK_HEADER = new byte[]{31, -117, 8, 4, 0, 0, 0, 0, 0, -1, 6, 0, 66, 67, 2, 0};
    private static final byte[] EOF_MARKER = new byte[28];
    private final CRC32 currentCrc32 = new CRC32();
    private int currentUsedBufferLength = 0;
    private long compressedBytesWrittenSoFar = 0L;
    private final byte[] uncompressedBuffer = new byte[65510];
    private final byte[] compressedBuffer = new byte[65536];
    private final OutputStream out;
    private final IndexerCallback callback;
    private final byte[] singleByteArray = new byte[1];

    BgzfOutputStream(File outputBam, IndexerCallback callback) throws IOException {
        if (outputBam == null) {
            throw new NullPointerException("output can not be null");
        }
        IOUtil.mkdirs(outputBam.getParentFile());
        this.out = new BufferedOutputStream(new FileOutputStream(outputBam), 65536);
        this.callback = callback;
    }

    @Override
    public void write(int b) throws IOException {
        this.singleByteArray[0] = (byte)b;
        this.handleWrite(this.singleByteArray, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.handleWrite(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.handleWrite(b, off, len);
    }

    private void handleWrite(byte[] b, int off, int bytesToWriteLength) throws IOException {
        if (bytesToWriteLength < 0) {
            throw new IndexOutOfBoundsException("length can not be negative : " + bytesToWriteLength);
        }
        if (this.callback == null) {
            this.handleWriteBody(b, off, bytesToWriteLength);
        } else {
            VirtualFileOffset start = this.getVirtualFileOffset();
            this.handleWriteBody(b, off, bytesToWriteLength);
            VirtualFileOffset end = this.getVirtualFileOffset();
            this.callback.encodedIndex(start, end);
        }
    }

    public VirtualFileOffset getVirtualFileOffset() {
        return VirtualFileOffset.create(this.compressedBytesWrittenSoFar, this.currentUsedBufferLength);
    }

    private void handleWriteBody(byte[] b, int off, int bytesToWriteLength) throws IOException {
        int bytesToWriteIntoCurrentBuffer;
        int currentOffset = off;
        for (int bytesLeftToWrite = bytesToWriteLength; bytesLeftToWrite > 0; bytesLeftToWrite -= bytesToWriteIntoCurrentBuffer) {
            int bytesFreeInBuffer = 65510 - this.currentUsedBufferLength;
            bytesToWriteIntoCurrentBuffer = Math.min(bytesLeftToWrite, bytesFreeInBuffer);
            System.arraycopy(b, currentOffset, this.uncompressedBuffer, this.currentUsedBufferLength, bytesToWriteIntoCurrentBuffer);
            this.currentUsedBufferLength += bytesToWriteIntoCurrentBuffer;
            currentOffset += bytesToWriteIntoCurrentBuffer;
            if (this.currentUsedBufferLength != 65510) continue;
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.currentUsedBufferLength > 0) {
            Deflater currentDeflater = new Deflater(5, true);
            currentDeflater.setInput(this.uncompressedBuffer, 0, this.currentUsedBufferLength);
            currentDeflater.finish();
            int compressedLength = currentDeflater.deflate(this.compressedBuffer);
            if (!currentDeflater.finished()) {
                Deflater noCompresessionDeflater = new Deflater(0, true);
                noCompresessionDeflater.setInput(this.uncompressedBuffer, 0, this.currentUsedBufferLength);
                noCompresessionDeflater.finish();
                compressedLength = noCompresessionDeflater.deflate(this.compressedBuffer);
                if (!noCompresessionDeflater.finished()) {
                    throw new IOException("could not compress block to fit max size");
                }
            }
            this.currentCrc32.reset();
            this.currentCrc32.update(this.uncompressedBuffer, 0, this.currentUsedBufferLength);
            ByteBuffer bgzfBlockBuffer = ByteBuffer.allocate(compressedLength + 26);
            bgzfBlockBuffer.order(ByteOrder.LITTLE_ENDIAN);
            bgzfBlockBuffer.put(BGZF_BLOCK_HEADER);
            bgzfBlockBuffer.putShort((short)(bgzfBlockBuffer.capacity() - 1));
            bgzfBlockBuffer.put(this.compressedBuffer, 0, compressedLength);
            bgzfBlockBuffer.putInt((int)this.currentCrc32.getValue());
            bgzfBlockBuffer.putInt(this.currentUsedBufferLength);
            bgzfBlockBuffer.flip();
            byte[] asBytes = new byte[bgzfBlockBuffer.remaining()];
            bgzfBlockBuffer.get(asBytes);
            this.out.write(asBytes);
            this.compressedBytesWrittenSoFar += (long)asBytes.length;
            this.currentUsedBufferLength = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.write(EOF_MARKER);
        this.out.close();
    }

    static {
        System.arraycopy(BGZF_BLOCK_HEADER, 0, EOF_MARKER, 0, BGZF_BLOCK_HEADER.length);
        BgzfOutputStream.EOF_MARKER[16] = 27;
        BgzfOutputStream.EOF_MARKER[18] = 3;
    }
}

