/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.sam.VirtualFileOffset;

class BgzfInputStream
extends InflaterInputStream {
    private static final int BGZF_XLEN_LENGTH = 6;
    private static final int GZIP_MAGIC_NUMBER = 35615;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int BGZF_MAGIC_NUMBER = 16963;
    private static final int BGZF_EXTRA_FIELDS_LENGTH = 8;
    private static final int BUFFER_SIZE = 65535;
    protected CRC32 crc = new CRC32();
    protected boolean eof;
    private volatile boolean closed = false;
    private long compressedBlockBytesReadSoFar = 0L;
    private int currentBlockSize;

    public static BgzfInputStream create(File bamFile) throws IOException {
        return new BgzfInputStream(bamFile);
    }

    static BgzfInputStream create(File bamFile, VirtualFileOffset vfs) throws IOException {
        long compressedBamBlockOffset = vfs.getCompressedBamBlockOffset();
        InputStream in = compressedBamBlockOffset > 0L ? new RandomAccessFileInputStream(bamFile, compressedBamBlockOffset) : new BufferedInputStream(new FileInputStream(bamFile));
        BgzfInputStream bgzfStream = new BgzfInputStream(in);
        IOUtil.blockingSkip(bgzfStream, vfs.getUncompressedOffset());
        return bgzfStream;
    }

    private BgzfInputStream(InputStream in, int size) throws IOException {
        super(in, new Inflater(true), size);
        this.parseBlockHeader(in);
    }

    public BgzfInputStream(File bam) throws IOException {
        this(new BufferedInputStream(new FileInputStream(bam), 65535));
    }

    private BgzfInputStream(InputStream in) throws IOException {
        this(in, 65535);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        this.assertNotClosed();
        if (!this.hasMoreData()) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        try {
            int bytesRead;
            while ((bytesRead = this.inf.inflate(buf, off, len)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    this.compressedBlockBytesReadSoFar += (long)this.currentBlockSize;
                    if (this.hasMoreBlocks()) {
                        return this.read(buf, off, len);
                    }
                    this.eof = true;
                    return -1;
                }
                if (!this.inf.needsInput()) continue;
                this.fill();
            }
            this.crc.update(buf, off, bytesRead);
            return bytesRead;
        }
        catch (DataFormatException e) {
            String s = e.getMessage();
            throw new IOException(s == null ? "Invalid ZLIB data format" : s, e);
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("BAM file is closed");
        }
    }

    public boolean hasMoreData() {
        return !this.eof;
    }

    VirtualFileOffset getCurrentVirutalFileOffset() {
        int uncompressedBytesReadInCurrentBlock = (int)this.inf.getBytesWritten();
        if (uncompressedBytesReadInCurrentBlock > 65535) {
            return VirtualFileOffset.create(this.compressedBlockBytesReadSoFar + (long)this.currentBlockSize, 0);
        }
        return VirtualFileOffset.create(this.compressedBlockBytesReadSoFar, uncompressedBytesReadInCurrentBlock);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.eof = true;
            this.closed = true;
            this.inf.end();
        }
    }

    private int parseBlockHeader(InputStream currentStream) throws IOException {
        CheckedInputStream in = new CheckedInputStream(currentStream, this.crc);
        this.crc.reset();
        if (IOUtil.readUnsignedShort(in, ByteOrder.LITTLE_ENDIAN) != 35615) {
            throw new ZipException("Not in GZIP format");
        }
        if (IOUtil.readUnsignedByte(in) != 8) {
            throw new ZipException("Unsupported compression method");
        }
        short flg = IOUtil.readUnsignedByte(in);
        IOUtil.blockingSkip(in, 6L);
        int headerLength = 10;
        this.currentBlockSize = this.parseCurrentBgzfBlockSize(in, flg);
        headerLength += 8;
        if ((flg & 8) == 8) {
            do {
                ++headerLength;
            } while (IOUtil.readUnsignedByte(in) != 0);
        }
        if ((flg & 0x10) == 16) {
            do {
                ++headerLength;
            } while (IOUtil.readUnsignedByte(in) != 0);
        }
        if ((flg & 2) == 2) {
            int v = (int)this.crc.getValue() & 0xFFFF;
            if (IOUtil.readUnsignedShort(in, ByteOrder.LITTLE_ENDIAN) != v) {
                throw new ZipException("Corrupt GZIP header");
            }
            headerLength += 2;
        }
        this.crc.reset();
        return headerLength;
    }

    private int parseCurrentBgzfBlockSize(CheckedInputStream in, int flg) throws IOException {
        if ((flg & 4) == 4) {
            int extraLength = IOUtil.readUnsignedShort(in, ByteOrder.LITTLE_ENDIAN);
            if (extraLength != 6) {
                throw new IOException("invalid BGZF file, F.EXTRA not correct length");
            }
            int magic = IOUtil.readUnsignedShort(in);
            if (magic != 16963) {
                throw new IOException("invalid BGZF file, F.EXTRA Subfield IDs are wrong " + Integer.toHexString(magic));
            }
            if (IOUtil.readUnsignedShort(in, ByteOrder.LITTLE_ENDIAN) != 2) {
                throw new IOException("invalid BGZF file, F.EXTRA payload length not 2");
            }
            return IOUtil.readUnsignedShort(in, ByteOrder.LITTLE_ENDIAN) + 1;
        }
        throw new IOException("invalid BGZF file, F.EXTRA not set");
    }

    private boolean hasMoreBlocks() throws IOException {
        InputStream in = this.in;
        int remaining = this.inf.getRemaining();
        if (remaining > 0) {
            in = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - remaining, remaining), in);
        }
        long actualCrc = this.crc.getValue();
        long expectedCrc = IOUtil.readUnsignedInt(in, ByteOrder.LITTLE_ENDIAN);
        if (expectedCrc != actualCrc) {
            throw new ZipException("invalid CRC: expected " + expectedCrc + " actual " + actualCrc);
        }
        if (IOUtil.readUnsignedInt(in, ByteOrder.LITTLE_ENDIAN) != (this.inf.getBytesWritten() & 0xFFFFFFFFL)) {
            throw new ZipException("invalid ISIZE");
        }
        if (this.in.available() > 0 || remaining > 26) {
            int m = 8;
            try {
            }
            catch (IOException ze) {
                return false;
            }
            this.inf.reset();
            if (remaining > (m += this.parseBlockHeader(in))) {
                this.inf.setInput(this.buf, this.len - remaining + m, remaining - m);
            }
            return true;
        }
        return false;
    }
}

