/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.sam;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.core.io.LineParser;
import org.jcvi.jillion.internal.sam.SamUtil;
import org.jcvi.jillion.sam.AbstractSamVisitor;
import org.jcvi.jillion.sam.SamParser;
import org.jcvi.jillion.sam.SamVisitor;
import org.jcvi.jillion.sam.SortOrder;
import org.jcvi.jillion.sam.header.SamHeader;
import org.jcvi.jillion.sam.header.SamHeaderBuilder;
import org.jcvi.jillion.sam.header.SamProgramBuilder;
import org.jcvi.jillion.sam.header.SamReadGroup;
import org.jcvi.jillion.sam.header.SamReadGroupBuilder;
import org.jcvi.jillion.sam.header.SamReferenceSequenceBuilder;
import org.jcvi.jillion.sam.header.SamVersion;

abstract class AbstractSamFileParser
implements SamParser {
    static final String COMMENT_KEY = "@CO";
    static final String PROGRAM_KEY = "@PG";
    static final String READ_GROUP_KEY = "@RG";
    static final String SEQUENCE_DICTIONARY_KEY = "@SQ";
    static final String HEADER_KEY = "@HD";
    private static final String HEADER_VERSION_TAG = "VN";
    private static final String HEADER_SORT_TAG = "SO";
    private static final Pattern HEADER_TAG_VALUE_PATTERN = Pattern.compile("([A-Za-z][A-Za-z0-9]):([ -~]+)");

    protected SamHeaderBuilder parseHeader(LineParser parser) throws IOException {
        SamHeaderBuilder headerBuilder = new SamHeaderBuilder();
        String currentLine = parser.peekLine();
        if (currentLine == null) {
            return headerBuilder;
        }
        if (currentLine.startsWith(HEADER_KEY)) {
            this.handleHeaderLine(currentLine, headerBuilder);
            parser.nextLine();
            currentLine = parser.peekLine();
        }
        boolean inHeader = true;
        while (currentLine != null && inHeader) {
            String trimmedLine = currentLine.trim();
            if (!trimmedLine.isEmpty()) {
                if (currentLine.startsWith(SEQUENCE_DICTIONARY_KEY)) {
                    this.handleSequenceDictionary(currentLine, headerBuilder);
                } else if (currentLine.startsWith(READ_GROUP_KEY)) {
                    this.handleReadGroup(currentLine, headerBuilder);
                } else if (currentLine.startsWith(PROGRAM_KEY)) {
                    this.handleProgram(currentLine, headerBuilder);
                } else if (currentLine.startsWith(COMMENT_KEY)) {
                    this.handleComment(currentLine, headerBuilder);
                } else {
                    inHeader = false;
                }
            }
            if (!inHeader) continue;
            parser.nextLine();
            currentLine = parser.peekLine();
        }
        return headerBuilder;
    }

    private void handleHeaderLine(String firstLine, SamHeaderBuilder headerBuilder) {
        Map<String, String> tags = this.parseTags(firstLine);
        SamVersion version = SamVersion.parseVersion(tags.get(HEADER_VERSION_TAG));
        headerBuilder.setVersion(version);
        headerBuilder.setSortOrder(SortOrder.parseSortOrder(tags.get(HEADER_SORT_TAG)));
    }

    private Map<String, String> parseTags(String line) {
        Matcher matcher = HEADER_TAG_VALUE_PATTERN.matcher(line);
        HashMap<String, String> map = new HashMap<String, String>();
        while (matcher.find()) {
            String tag = matcher.group(1);
            String value = matcher.group(2);
            map.put(tag, value);
        }
        return map;
    }

    void handleComment(String line, SamHeaderBuilder headerBuilder) {
        headerBuilder.addComment(line.substring(3).trim());
    }

    void handleProgram(String line, SamHeaderBuilder headerBuilder) {
        Map<String, String> tags = this.parseTags(line);
        String id = tags.get("ID");
        SamProgramBuilder builder = new SamProgramBuilder(id);
        if (tags.containsKey("PN")) {
            builder.setName(tags.get("PN"));
        }
        if (tags.containsKey("CL")) {
            builder.setCommandLine(tags.get("CL"));
        }
        if (tags.containsKey("PP")) {
            builder.setPrevousProgramId(tags.get("PP"));
        }
        if (tags.containsKey("DS")) {
            builder.setDescription(tags.get("DS"));
        }
        if (tags.containsKey(HEADER_VERSION_TAG)) {
            builder.setVersion(tags.get(HEADER_VERSION_TAG));
        }
        headerBuilder.addProgram(builder.build());
    }

    void handleReadGroup(String line, SamHeaderBuilder headerBuilder) {
        Map<String, String> tags = this.parseTags(line);
        String id = tags.get("ID");
        SamReadGroupBuilder builder = new SamReadGroupBuilder(id);
        if (tags.containsKey("CN")) {
            builder.setSequencingCenter(tags.get("CN"));
        }
        if (tags.containsKey("DS")) {
            builder.setDescription(tags.get("DS"));
        }
        if (tags.containsKey("DT")) {
            try {
                Date date = SamUtil.toDate(tags.get("DT"));
                builder.setRunDate(date);
            }
            catch (ParseException e) {
                throw new IllegalStateException("invalid date format : " + tags.get("DT"), e);
            }
        }
        if (tags.containsKey("FO")) {
            NucleotideSequence flowOrder = new NucleotideSequenceBuilder(tags.get("FO")).build();
            builder.setFlowOrder(flowOrder);
        }
        if (tags.containsKey("KS")) {
            NucleotideSequence keySequence = new NucleotideSequenceBuilder(tags.get("KS")).build();
            builder.setKeySequence(keySequence);
        }
        if (tags.containsKey("LB")) {
            builder.setLibrary(tags.get("LB"));
        }
        if (tags.containsKey("PG")) {
            builder.setPrograms(tags.get("PG"));
        }
        if (tags.containsKey("PI")) {
            int insertSize = Integer.parseInt(tags.get("PI"));
            builder.setPredictedInsertSize(insertSize);
        }
        if (tags.containsKey("PL")) {
            String value = tags.get("PL");
            SamReadGroup.PlatformTechnology platform = SamReadGroup.PlatformTechnology.parse(value);
            builder.setPlatform(platform);
        }
        if (tags.containsKey("PU")) {
            builder.setPlatformUnit(tags.get("PU"));
        }
        if (tags.containsKey("SM")) {
            builder.setSampleOrPoolName(tags.get("SM"));
        }
        headerBuilder.addReadGroup(builder.build());
    }

    void handleSequenceDictionary(String line, SamHeaderBuilder headerBuilder) {
        Map<String, String> tags = this.parseTags(line);
        String name = tags.get("SN");
        int length = Integer.parseInt(tags.get("LN"));
        SamReferenceSequenceBuilder builder = new SamReferenceSequenceBuilder(name, length);
        if (tags.containsKey("AS")) {
            builder.setGenomeAssemblyId(tags.get("AS"));
        }
        if (tags.containsKey("M5")) {
            builder.setMd5(tags.get("M5"));
        }
        if (tags.containsKey("SP")) {
            builder.setSpecies(tags.get("SP"));
        }
        if (tags.containsKey("UR")) {
            builder.setUri(tags.get("UR"));
        }
        headerBuilder.addReferenceSequence(builder.build());
    }

    @Override
    public SamHeader getHeader() throws IOException {
        final SamHeader[] headerArray = new SamHeader[1];
        this.parse(new AbstractSamVisitor(){

            @Override
            public void visitHeader(SamVisitor.SamVisitorCallback callback, SamHeader header) {
                headerArray[0] = header;
                callback.haltParsing();
            }
        });
        return headerArray[0];
    }

    static abstract class AbstractCallback
    implements SamVisitor.SamVisitorCallback {
        private final AtomicBoolean keepParsing;

        public AbstractCallback(AtomicBoolean keepParsing) {
            this.keepParsing = keepParsing;
        }

        @Override
        public void haltParsing() {
            this.keepParsing.set(false);
        }

        public boolean keepParsing() {
            return this.keepParsing.get();
        }
    }
}

