/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.profile;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.profile.BaseCount;
import org.jcvi.jillion.profile.DisplayCountStrategy;
import org.jcvi.jillion.profile.MostFrequentTieBreakerRule;
import org.jcvi.jillion.profile.ProfileWriter;

class SimpleProfileWriter
implements ProfileWriter {
    private final MostFrequentTieBreakerRule tieBreakerRule;
    private final PrintWriter writer;
    private final DisplayCountStrategy lineWriterStrategy;
    private final double[][] counts;
    private final NucleotideSequence reference;
    private final boolean include0xEdges;
    private final boolean ignoreGappedConsensusPositions;
    private volatile boolean isOpen = true;

    public SimpleProfileWriter(File outputFile, DisplayCountStrategy displayStrategy, MostFrequentTieBreakerRule tieBreakerRule, NucleotideSequence referenceOfConsensus, boolean include0xEdges, boolean ignoreGappedConsensusPositions) throws IOException {
        IOUtil.mkdirs(outputFile.getParentFile());
        this.writer = new PrintWriter(outputFile, "UTF-8");
        this.lineWriterStrategy = displayStrategy;
        this.counts = new double[(int)referenceOfConsensus.getLength()][5];
        this.tieBreakerRule = tieBreakerRule;
        this.reference = referenceOfConsensus;
        this.include0xEdges = include0xEdges;
        this.ignoreGappedConsensusPositions = ignoreGappedConsensusPositions;
    }

    public SimpleProfileWriter(OutputStream out, DisplayCountStrategy displayStrategy, MostFrequentTieBreakerRule tieBreakerRule, NucleotideSequence referenceOfConsensus, boolean include0xEdges, boolean ignoreGappedConsensusPositions) {
        this.writer = new PrintWriter(new OutputStreamWriter(out, IOUtil.UTF_8));
        this.lineWriterStrategy = displayStrategy;
        this.counts = new double[(int)referenceOfConsensus.getLength()][5];
        this.tieBreakerRule = tieBreakerRule;
        this.reference = referenceOfConsensus;
        this.include0xEdges = include0xEdges;
        this.ignoreGappedConsensusPositions = ignoreGappedConsensusPositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        try {
            this.isOpen = false;
            this.writer.printf("#Major\t-\tA\tC\tG\tT%n", new Object[0]);
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            if (this.ignoreGappedConsensusPositions) {
                int[] gapOffsets = this.reference.getGapOffsets().stream().mapToInt(i -> i).toArray();
                for (int i2 = start; i2 <= end; ++i2) {
                    if (Arrays.binarySearch(gapOffsets, i2) >= 0) continue;
                    Nucleotide mostFreq = this.getMostFrequentBase(i2, this.counts[i2][0], this.counts[i2][1], this.counts[i2][2], this.counts[i2][3]);
                    this.lineWriterStrategy.write(this.writer, mostFreq, this.counts[i2][4], this.counts[i2][0], this.counts[i2][1], this.counts[i2][2], this.counts[i2][3]);
                }
            } else {
                for (int i3 = start; i3 <= end; ++i3) {
                    Nucleotide mostFreq = this.getMostFrequentBase(i3, this.counts[i3][0], this.counts[i3][1], this.counts[i3][2], this.counts[i3][3]);
                    this.lineWriterStrategy.write(this.writer, mostFreq, this.counts[i3][4], this.counts[i3][0], this.counts[i3][1], this.counts[i3][2], this.counts[i3][3]);
                }
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)this.writer);
        }
    }

    protected double getAs(int offset) {
        return this.counts[offset][0];
    }

    protected double getCs(int offset) {
        return this.counts[offset][1];
    }

    protected double getGs(int offset) {
        return this.counts[offset][2];
    }

    protected double getTs(int offset) {
        return this.counts[offset][3];
    }

    protected double getGaps(int offset) {
        return this.counts[offset][4];
    }

    private boolean is0x(int i) {
        return this.getAs(i) == 0.0 && this.getCs(i) == 0.0 && this.getGs(i) == 0.0 && this.getTs(i) == 0.0 && this.getGaps(i) == 0.0;
    }

    protected int getStartOffset() {
        if (this.include0xEdges) {
            return 0;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            if (this.is0x(i)) continue;
            return i;
        }
        return -1;
    }

    protected int getEndOffset() {
        if (this.include0xEdges) {
            return this.getLength() - 1;
        }
        for (int i = this.getLength() - 1; i > 0; --i) {
            if (this.is0x(i)) continue;
            return i;
        }
        return -1;
    }

    protected int getLength() {
        return this.counts.length;
    }

    protected Nucleotide getMostFrequentBase(int i, double a, double c, double g, double t) {
        if (a == 0.0 && c == 0.0 && g == 0.0 && t == 0.0 && this.getGaps(i) == 0.0) {
            return (Nucleotide)this.reference.get(i);
        }
        return this.getMostFrequentNonGapBase(a, c, g, t);
    }

    @Override
    public void addSequence(int startOffset, NucleotideSequence sequence) {
        int currentOffset = startOffset;
        for (Nucleotide n : sequence) {
            Set<Nucleotide> bases = n.getBasesFor();
            double fraction = 1.0 / (double)bases.size();
            block8: for (Nucleotide base : bases) {
                switch (base) {
                    case Adenine: {
                        double[] dArray = this.counts[currentOffset];
                        dArray[0] = dArray[0] + fraction;
                        continue block8;
                    }
                    case Cytosine: {
                        double[] dArray = this.counts[currentOffset];
                        dArray[1] = dArray[1] + fraction;
                        continue block8;
                    }
                    case Guanine: {
                        double[] dArray = this.counts[currentOffset];
                        dArray[2] = dArray[2] + fraction;
                        continue block8;
                    }
                    case Thymine: {
                        double[] dArray = this.counts[currentOffset];
                        dArray[3] = dArray[3] + fraction;
                        continue block8;
                    }
                    case Gap: {
                        double[] dArray = this.counts[currentOffset];
                        dArray[4] = dArray[4] + fraction;
                        continue block8;
                    }
                }
                throw new IllegalStateException("not ACGT- : " + base);
            }
            ++currentOffset;
        }
    }

    private Nucleotide getMostFrequentNonGapBase(double a, double c, double g, double t) {
        ArrayList<BaseCount> list = new ArrayList<BaseCount>(4);
        list.add(new BaseCount(Nucleotide.Adenine, a));
        list.add(new BaseCount(Nucleotide.Cytosine, c));
        list.add(new BaseCount(Nucleotide.Guanine, g));
        list.add(new BaseCount(Nucleotide.Thymine, t));
        Collections.sort(list);
        ArrayList<Nucleotide> mostFrequent = new ArrayList<Nucleotide>(4);
        Iterator iter = list.iterator();
        BaseCount first = (BaseCount)iter.next();
        mostFrequent.add(first.getBase());
        double value = first.getCount();
        boolean done = false;
        do {
            BaseCount next;
            boolean bl = done = (next = (BaseCount)iter.next()).getCount() < value;
            if (done) continue;
            mostFrequent.add(next.getBase());
        } while (!done && iter.hasNext());
        if (mostFrequent.size() > 1) {
            return this.tieBreakerRule.getMostFrequent(mostFrequent);
        }
        return (Nucleotide)mostFrequent.get(0);
    }
}

