/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.profile;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.profile.DisplayCountStrategy;
import org.jcvi.jillion.profile.MostFrequentTieBreakerRule;
import org.jcvi.jillion.profile.ProfileWriter;
import org.jcvi.jillion.profile.SimpleProfileWriter;

public class ProfileWriterBuilder {
    private final File outputFile;
    private final OutputStream outStream;
    private DisplayCountStrategy displayPercentages = DisplayCountStrategy.COUNTS;
    private final NucleotideSequence referenceOrConsensus;
    private MostFrequentTieBreakerRule tieBreakerRule = MostFrequentTieBreakerRule.LOWEST_ASCII;
    private boolean include0xEdges = true;
    private boolean ignoreGappedConsensusPositions = false;

    public ProfileWriterBuilder(File outputFile, NucleotideSequence referenceOrConsensus) {
        Objects.requireNonNull(outputFile);
        Objects.requireNonNull(referenceOrConsensus);
        this.verifySequenceLength(referenceOrConsensus);
        this.outputFile = outputFile;
        this.outStream = null;
        this.referenceOrConsensus = referenceOrConsensus;
    }

    public ProfileWriterBuilder(OutputStream out, NucleotideSequence referenceOrConsensus) {
        Objects.requireNonNull(out);
        Objects.requireNonNull(referenceOrConsensus);
        this.verifySequenceLength(referenceOrConsensus);
        this.outputFile = null;
        this.outStream = out;
        this.referenceOrConsensus = referenceOrConsensus;
    }

    private void verifySequenceLength(NucleotideSequence seq) {
        if (seq.getLength() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("reference sequence too long, max length is 2^31-1 but this is %d", seq.getLength()));
        }
    }

    public ProfileWriterBuilder setMostFrequentTieBreakerRule(MostFrequentTieBreakerRule tieBreakerRule) {
        Objects.requireNonNull(tieBreakerRule);
        this.tieBreakerRule = tieBreakerRule;
        return this;
    }

    public ProfileWriterBuilder include0xEdges(boolean include0xEdges) {
        this.include0xEdges = include0xEdges;
        return this;
    }

    public ProfileWriterBuilder displayPercentages(DisplayCountStrategy displayPercentages) {
        this.displayPercentages = displayPercentages;
        return this;
    }

    public ProfileWriter build() throws IOException {
        if (this.outputFile == null) {
            return new SimpleProfileWriter(this.outStream, this.displayPercentages, this.tieBreakerRule, this.referenceOrConsensus, this.include0xEdges, this.ignoreGappedConsensusPositions);
        }
        return new SimpleProfileWriter(this.outputFile, this.displayPercentages, this.tieBreakerRule, this.referenceOrConsensus, this.include0xEdges, this.ignoreGappedConsensusPositions);
    }

    public ProfileWriterBuilder ignoreGappedConsensusPositions(boolean ignoreGappedConsensusPositions) {
        this.ignoreGappedConsensusPositions = ignoreGappedConsensusPositions;
        return this;
    }
}

