/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.profile;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

public enum MostFrequentTieBreakerRule {
    LOWEST_ASCII{

        @Override
        Nucleotide getMostFrequent(List<Nucleotide> mostFrequentBases) {
            Iterator<Nucleotide> iter = mostFrequentBases.iterator();
            Nucleotide n = iter.next();
            char value = n.getCharacter().charValue();
            while (iter.hasNext()) {
                Nucleotide current = iter.next();
                char currentValue = current.getCharacter().charValue();
                if (currentValue >= value) continue;
                n = current;
                value = currentValue;
            }
            return n;
        }
    }
    ,
    RANDOM{
        Random rnd = new Random();

        @Override
        Nucleotide getMostFrequent(List<Nucleotide> mostFrequentBases) {
            return mostFrequentBases.get(this.rnd.nextInt(mostFrequentBases.size()));
        }
    }
    ,
    AMBIGUITY{

        @Override
        Nucleotide getMostFrequent(List<Nucleotide> mostFrequentBases) {
            return Nucleotide.getAmbiguityFor(mostFrequentBases);
        }
    };


    abstract Nucleotide getMostFrequent(List<Nucleotide> var1);
}

